/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style.wizard;

import com.jaspersoft.studio.editor.style.wizard.WizardHelpNewFileCreationPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class StyleTemplateNewWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "com.jaspersoft.studio.wizards.StyleTemplateNewWizard";
    private static final String NEW_STYLE_NAME = "NEW_STYLE";
    private static final String NEW_STYLE_EXT = ".jrtx";
    protected static final String NEW_STYLE_JRTX = "NEW_STYLE.jrtx";
    protected WizardNewFileCreationPage step1;
    protected ISelection selection;
    protected IFile file = null;
    protected IFile reportFile = null;

    public StyleTemplateNewWizard() {
        this.setWindowTitle(Messages.StyleTemplateNewWizard_wizardtitle);
        this.setNeedsProgressMonitor(true);
        JDTUtils.deactivateLinkedResourcesSupport();
    }

    public void addPages() {
        this.step1 = this.getDestinationPage();
        this.setupNewFileName();
        this.addPage((IWizardPage)this.step1);
    }

    public void setupNewFileName() {
        String filename = NEW_STYLE_JRTX;
        if (this.selection != null) {
            TreeSelection s;
            if (this.selection instanceof TreeSelection && (s = (TreeSelection)this.selection).getFirstElement() instanceof IFile) {
                IFile file = (IFile)s.getFirstElement();
                String f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                int i = 1;
                while (file.getProject().getFile(f).exists()) {
                    filename = NEW_STYLE_NAME + i + NEW_STYLE_EXT;
                    f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                    ++i;
                }
            }
            this.step1.setFileName(filename);
        }
    }

    protected WizardNewFileCreationPage getDestinationPage() {
        WizardHelpNewFileCreationPage page = new WizardHelpNewFileCreationPage("newFilePage1", (IStructuredSelection)this.selection);
        page.setTitle(Messages.StyleTemplateNewWizard_title);
        page.setDescription(Messages.StyleTemplateNewWizard_description);
        page.setFileExtension("jrtx");
        return page;
    }

    public boolean performFinish() {
        JDTUtils.restoreLinkedResourcesSupport();
        final String containerName = this.step1.getContainerFullPath().toPortableString();
        final String fileName = this.step1.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        StyleTemplateNewWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        JDTUtils.restoreLinkedResourcesSupport();
        return super.performCancel();
    }

    public boolean canFinish() {
        if (JDTUtils.isVirtualResource((IPath)this.step1.getContainerFullPath())) {
            this.step1.setMessage(Messages.StyleTemplateNewWizard_VirtualFolderErr, 4);
            return false;
        }
        return super.canFinish();
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        if (resource.isVirtual()) {
            this.throwCoreException("Container \"" + containerName + "\" is a virtual folder.");
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StyleTemplateNewWizard.this.file = StyleTemplateNewWizard.this.step1.createNewFile();
            }
        });
        InputStream in = null;
        try {
            in = this.openContentStream();
            if (this.file.exists()) {
                this.file.setContents(in, true, true, monitor);
            } else {
                this.file.create(in, true, monitor);
            }
            this.reportFile = this.file;
        }
        finally {
            FileUtils.closeStream((Closeable)in);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.openEditor(this.file);
        monitor.worked(1);
    }

    protected void openEditor(final IFile file) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public IFile getReportFile() {
        return this.reportFile;
    }

    protected InputStream openContentStream() {
        JasperReportsConfiguration jConf = null;
        try {
            JRSimpleTemplate tmp = new JRSimpleTemplate();
            JRDesignStyle jrDesignStyle = new JRDesignStyle();
            jrDesignStyle.setName("SimpleStyle");
            tmp.addStyle((JRStyle)jrDesignStyle);
            jConf = this.file != null ? JasperReportsConfiguration.getDefaultJRConfig(this.file) : (this.reportFile != null ? JasperReportsConfiguration.getDefaultJRConfig(this.reportFile) : JasperReportsConfiguration.getDefaultJRConfig());
            jConf.setProperty("net.sf.jasperreports.report.version", jConf.getProperty("com.jaspersoft.studio.compatibility.version"));
            String contents = JRXmlTemplateWriter.writeTemplate((JasperReportsContext)jConf, (JRTemplate)tmp);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents.getBytes());
            return byteArrayInputStream;
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        finally {
            jConf.dispose();
        }
        return null;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.jaspersoft.studio", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof StructuredSelection) {
            IProject p;
            IProject[] prjs;
            if (selection.getFirstElement() instanceof IProject || selection.getFirstElement() instanceof IFile || selection.getFirstElement() instanceof IFolder || selection.getFirstElement() instanceof IPackageFragment) {
                this.selection = selection;
                return;
            }
            for (Object obj : selection.toList()) {
                IEditorInput ein;
                if (!(obj instanceof EditPart) || !((ein = SelectionHelper.getActiveJRXMLEditor().getEditorInput()) instanceof FileEditorInput)) continue;
                this.selection = new TreeSelection(new TreePath(new Object[]{((FileEditorInput)ein).getFile()}));
                return;
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = prjs.length;
            int n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p) && p.getNature("org.eclipse.jdt.core.javanature") != null) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_STYLE_JRTX)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            iProjectArray = prjs;
            n = prjs.length;
            n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p)) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_STYLE_JRTX)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.selection = selection;
    }
}

