/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.toolitems;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.toolitems.ToolItemsSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class ToolItemsManager {
    private static final Map<String, Boolean> staticDefaultValues = new HashMap<String, Boolean>();
    private List<ToolItemsSet> sets = new ArrayList<ToolItemsSet>();
    private Map<String, String> itemsSetMap = new HashMap<String, String>();

    static {
        staticDefaultValues.put("com.jaspersoft.studio.graphic.bring", false);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.text", true);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.create", true);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.align", false);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.size", true);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.borders", false);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.image", true);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.exporters", false);
        staticDefaultValues.put("com.jaspersoft.studio.graphic.movebands", false);
        staticDefaultValues.put("com.jaspersoft.studio.components.tableactions", true);
        staticDefaultValues.put("com.jaspersoft.studio.components.crosstabaction", true);
    }

    public boolean isToolbarVisible(String controlId) {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String toolbarID = this.itemsSetMap.get(controlId);
        if (toolbarID == null) {
            return false;
        }
        return store.getBoolean(toolbarID);
    }

    public void init() {
        IConfigurationElement[] cToolItemSets;
        IConfigurationElement[] iConfigurationElementArray = cToolItemSets = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.toolitemsets");
        int n = cToolItemSets.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolbar = iConfigurationElementArray[n2];
            IConfigurationElement[] controls = toolbar.getChildren("toolitem");
            String toolbarId = toolbar.getAttribute("id");
            ToolItemsSet set = new ToolItemsSet();
            set.setId(toolbarId);
            set.setName(toolbar.getAttribute("label"));
            Boolean defaultVisible = staticDefaultValues.get(toolbarId);
            if (defaultVisible != null) {
                set.setVisible(defaultVisible);
            } else {
                set.setVisible(false);
            }
            this.sets.add(set);
            IConfigurationElement[] iConfigurationElementArray2 = controls;
            int n3 = controls.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement control = iConfigurationElementArray2[n4];
                String controlId = control.getAttribute("id");
                this.itemsSetMap.put(controlId, toolbarId);
                set.addControlConfiguration(control);
                ++n4;
            }
            ++n2;
        }
    }

    public List<ToolItemsSet> getSets() {
        return this.sets;
    }

    public String getParentToolbarId(String controlId) {
        return this.itemsSetMap.get(controlId);
    }
}

