/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementDefinitionWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class CreateCompositeElementAction
extends ACachedSelectionAction {
    public static final String ID = "CreateCompositeElementAction";

    public CreateCompositeElementAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateToolAction_actionName);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/custom-tool.png"));
        this.setEnabled(false);
    }

    private boolean hasDataset(List<?> elements) {
        for (Object obj : elements) {
            if (obj instanceof IDatasetContainer) {
                return true;
            }
            ANode node = (ANode)obj;
            boolean checkContent = this.hasDataset(node.getChildren());
            if (!checkContent) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (mGraphElements.isEmpty()) {
            return false;
        }
        return !this.hasDataset(mGraphElements);
    }

    @Override
    public void run() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)new CompositeElementDefinitionWizard(mGraphElements));
        if (dialog.open() == 0) {
            UIUtils.showInformation((String)Messages.CreateToolAction_successMessage);
        }
    }
}

