/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.CompositeElementTemplateCreationEntry;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;

public class DeleteCompositeElementAction
extends Action {
    private CompositeElementTemplateCreationEntry elementToDelete;

    public DeleteCompositeElementAction(CompositeElementTemplateCreationEntry elementToDelete) {
        this.setText(Messages.DeleteToolAction_actionName);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/delete_style.gif"));
        this.elementToDelete = elementToDelete;
    }

    public void run() {
        MCompositeElement element = this.elementToDelete.getTemplate();
        String question = MessageFormat.format(Messages.DeleteToolAction_messageDescription, element.getName());
        boolean confirmDelete = UIUtils.showConfirmation((String)Messages.DeleteToolAction_messageTitle, (String)question);
        if (confirmDelete) {
            CompositeElementManager.INSTANCE.deleteCompositeElement(element);
            try {
                IWorkspaceRoot root;
                IFile[] files;
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.getPath()));
                if (!fileStore.fetchInfo().isDirectory() && (files = (root = ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(fileStore.toURI())) != null && files.length > 0) {
                    files[0].delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEnabled() {
        return this.elementToDelete != null;
    }
}

