/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementImportWizard;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.ZipUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;

public class ImportCompositeElementAction
extends Action {
    public ImportCompositeElementAction() {
        this.setText(Messages.ImportCompositeElementAction_actionName);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/import.png"));
    }

    public void run() {
        String destinationPath = this.getDestinationPath();
        if (destinationPath != null) {
            File tempFolder = this.createTempFolder();
            ZipUtils zipUtils = new ZipUtils();
            zipUtils.unZipFiles(destinationPath, tempFolder.getAbsolutePath());
            List<MCompositeElement> elementsFound = CompositeElementManager.INSTANCE.loadCompositeElements(tempFolder);
            if (!elementsFound.isEmpty()) {
                CompositeElementImportWizard wizard = new CompositeElementImportWizard(elementsFound);
                WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
                dialog.setPageSize(200, -1);
                dialog.open();
            }
            try {
                FileUtils.deleteDirectory((File)tempFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getDestinationPath() {
        FileDialog dialog = new FileDialog(UIUtils.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFilterPath(System.getProperty("user.home"));
        return dialog.open();
    }

    private File createTempFolder() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File destFolder = new File(tmpDir, "compositeElementImport");
        int index = 0;
        while (destFolder.exists()) {
            destFolder = new File(tmpDir, "compositeElementImport" + index);
            ++index;
        }
        destFolder.deleteOnExit();
        return destFolder;
    }
}

