/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementTemplateCreationEntry;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenElementInDesignerAction
extends Action {
    private CompositeElementTemplateCreationEntry elementToEdit;

    public OpenElementInDesignerAction(CompositeElementTemplateCreationEntry elementToEdit) {
        this.setText(Messages.OpenInDesignerToolAction_actionName);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/tool_open_in_editor.png"));
        this.elementToEdit = elementToEdit;
    }

    public void run() {
        MCompositeElement element = this.elementToEdit.getTemplate();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.getPath()));
            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.elementToEdit != null;
    }
}

