/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.palette.JDPaletteFactory;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.plugin.PaletteGroup;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositeElementDefinitionWizardPage
extends JSSHelpWizardPage {
    protected static final String DEFAULT_PALETTE = "defaultCustomElementsPalette";
    private String name = "";
    private String elementDescription = "";
    private String iconPath = "";
    private String groupID = "";
    protected Text nameText;
    protected Text descriptionText;
    protected Combo palettePosition;
    protected Text iconPathText;
    protected List<PaletteGroup> groups = this.getAvailableGroups();
    private Label iconPreview;
    private Image lastLoadedImage = null;
    protected ModifyListener widgetsModfied = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CompositeElementDefinitionWizardPage.this.updateWidgets();
        }
    };

    protected CompositeElementDefinitionWizardPage() {
        super("elementdefinitionwizard");
        this.setTitle(Messages.ToolDefinitionWizardPage_title);
        this.setDescription(Messages.ToolDefinitionWizardPage_description);
    }

    protected void updateWidgets() {
        this.name = this.nameText.getText();
        this.elementDescription = this.descriptionText.getText();
        PaletteGroup selectedGroup = this.groups.get(this.palettePosition.getSelectionIndex());
        this.groupID = selectedGroup.getId();
        PreferencesUtils.getJaspersoftStudioPrefStore().setValue(DEFAULT_PALETTE, this.groupID);
        if (!this.iconPath.equals(this.iconPathText.getText())) {
            this.iconPath = this.iconPathText.getText();
            try {
                this.loadIconSample();
            }
            catch (Exception exception) {
                this.iconPreview.setImage(null);
                GridData iconLabelData = new GridData();
                iconLabelData.exclude = true;
                this.iconPreview.setLayoutData((Object)iconLabelData);
                this.iconPreview.getParent().layout(true, true);
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateWidgets();
        }
    }

    protected void createIconArea(Composite container) {
        Composite imageContainer = new Composite(container, 0);
        imageContainer.setLayoutData((Object)new GridData(768));
        GridLayout imageContainerLayout = new GridLayout(3, false);
        imageContainerLayout.marginHeight = 0;
        imageContainerLayout.marginWidth = 0;
        imageContainer.setLayout((Layout)imageContainerLayout);
        this.iconPathText = new Text(imageContainer, 2048);
        this.iconPathText.setLayoutData((Object)new GridData(768));
        this.iconPreview = new Label(imageContainer, 0);
        GridData previewData = new GridData();
        previewData.exclude = true;
        this.iconPreview.setLayoutData((Object)previewData);
        Button selectImageButton = new Button(imageContainer, 8);
        selectImageButton.setText(Messages.common_browse);
        selectImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell(), 4096);
                fd.setText(Messages.common_open);
                fd.setFilterExtensions(CompositeElementDefinitionWizardPage.this.getFileExtensions());
                fd.setFilterNames(CompositeElementDefinitionWizardPage.this.getFileExtensionsNames());
                String selected = fd.open();
                if (selected != null) {
                    CompositeElementDefinitionWizardPage.this.iconPathText.setText(selected);
                }
            }
        });
    }

    protected String[] getFileExtensionsNames() {
        return new String[]{"All Images", "PNG", "JPEG", "GIF", "SVG", "ICO"};
    }

    protected String[] getFileExtensions() {
        return new String[]{"*.png;*.jpeg;*.jpg;*.gif;*.svg;*.ico", "*.png", "*.jpeg; *.jpg", "*.gif", ".svg", "*.ico"};
    }

    protected List<PaletteGroup> getAvailableGroups() {
        ArrayList<PaletteGroup> result = new ArrayList<PaletteGroup>();
        result.add(JDPaletteFactory.getBaseElementsGroup());
        result.add(JDPaletteFactory.getOtherElementsGroup());
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        result.addAll(m.getPaletteGroups());
        return result;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        new Label(container, 0).setText(Messages.ToolDefinitionWizardPage_titleLabel);
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.getFirstAvailableName());
        new Label(container, 0).setText(Messages.ToolDefinitionWizardPage_descriptionLabel);
        this.descriptionText = new Text(container, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(Messages.ToolDefinitionWizardPage_iconLabel);
        this.createIconArea(container);
        new Label(container, 0).setText("Position in Palette");
        this.palettePosition = new Combo(container, 8);
        this.palettePosition.setData(this.groups);
        ArrayList<String> entries = new ArrayList<String>();
        for (PaletteGroup group : this.groups) {
            entries.add(group.getName());
        }
        this.palettePosition.setItems(entries.toArray(new String[entries.size()]));
        new File("fdsdfswd").getAbsolutePath();
        String defaultPalette = PreferencesUtils.getJaspersoftStudioPrefStore().getString(DEFAULT_PALETTE);
        int initialIndex = 1;
        if (defaultPalette != null) {
            int i = 0;
            while (i < this.groups.size()) {
                PaletteGroup group = this.groups.get(i);
                if (group.getId().equals(defaultPalette)) {
                    initialIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.groupID = this.groups.get(initialIndex).getId();
        this.palettePosition.select(initialIndex);
        this.setControl((Control)container);
        this.addListeners();
    }

    protected void addListeners() {
        this.nameText.addModifyListener(this.widgetsModfied);
        this.descriptionText.addModifyListener(this.widgetsModfied);
        this.iconPathText.addModifyListener(this.widgetsModfied);
        this.palettePosition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeElementDefinitionWizardPage.this.updateWidgets();
            }
        });
    }

    public boolean isPageComplete() {
        if (this.name.trim().isEmpty()) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameEmpry);
        } else if (!FileUtils.isValidFilename((String)this.name)) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_invalidFileName);
        } else if (CompositeElementManager.INSTANCE.isNameAlreadyUsed(this.name.trim())) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameUsed);
        } else {
            this.setErrorMessage(null);
            this.setDescription(Messages.ToolDefinitionWizardPage_description);
        }
        return this.getErrorMessage() == null;
    }

    private String getFirstAvailableName() {
        String baseName;
        String name = baseName = Messages.ToolDefinitionWizardPage_defaultName;
        int counter = 1;
        while (CompositeElementManager.INSTANCE.isNameAlreadyUsed(name)) {
            name = String.valueOf(baseName) + " " + counter;
            ++counter;
        }
        return name;
    }

    private void loadIconSample() throws FileNotFoundException {
        FileInputStream stream = null;
        if (this.lastLoadedImage != null) {
            this.lastLoadedImage.dispose();
        }
        try {
            stream = new FileInputStream(new File(this.iconPath));
            Image loadedImage = new Image(null, (InputStream)stream);
            ImageData resized = ImageUtils.resizeKeepingRatio(16, loadedImage);
            loadedImage.dispose();
            FileUtils.closeStream((Closeable)stream);
            this.lastLoadedImage = new Image(null, resized);
            this.iconPreview.setImage(this.lastLoadedImage);
            GridData iconLabelData = new GridData();
            iconLabelData.widthHint = resized.width;
            this.iconPreview.setLayoutData((Object)iconLabelData);
            this.iconPreview.getParent().layout(true, true);
        }
        catch (FileNotFoundException ex) {
            FileUtils.closeStream(stream);
            throw ex;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.lastLoadedImage != null) {
            this.lastLoadedImage.dispose();
            this.lastLoadedImage = null;
        }
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_COMPOSITE_ELEMENTS;
    }

    public String getName() {
        return this.name;
    }

    public String getElementDescription() {
        return this.elementDescription;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public static String getFirstAvailableImagePath(MCompositeElement element) {
        String imagePath = element.getIconPathBig();
        if (imagePath == null) {
            imagePath = element.getIconPathSmall();
        }
        return imagePath;
    }
}

