/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementEditWizardPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.wizard.IWizardPage;

public class CompositeElementImportWizardPage
extends CompositeElementEditWizardPage {
    private MCompositeElement elementToImport;
    private String description;

    public CompositeElementImportWizardPage(MCompositeElement elementToImport, int currentElement, int totalElements) {
        super(elementToImport.getName(), elementToImport.getDescription(), elementToImport.getGroupId(), CompositeElementImportWizardPage.getFirstAvailableImagePath(elementToImport));
        this.elementToImport = elementToImport;
        this.description = MessageFormat.format(Messages.CompositeElementImportWizardPage_pageDescription, currentElement, totalElements);
        this.setTitle(Messages.CompositeElementImportWizardPage_pageTitle);
        this.setDescription(this.description);
    }

    protected boolean isNameUsedInOtherPage() {
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            CompositeElementImportWizardPage importPage = (CompositeElementImportWizardPage)page;
            if (importPage != this && ModelUtils.safeEquals(importPage.getName(), this.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPageComplete() {
        String name = this.getName().trim();
        if (name.isEmpty()) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameEmpry);
        } else if (!FileUtils.isValidFilename((String)name)) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_invalidFileName);
        } else if (CompositeElementManager.INSTANCE.isNameAlreadyUsed(name.trim())) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameUsed);
        } else if (this.isNameUsedInOtherPage()) {
            this.setErrorMessage(Messages.CompositeElementImportWizardPage_errorNameUsed);
        } else {
            this.setErrorMessage(null);
            this.setDescription(this.description);
        }
        return this.getErrorMessage() == null;
    }

    public MCompositeElement getElementToImport() {
        return this.elementToImport;
    }
}

