/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml;

import com.jaspersoft.studio.editor.xml.IXMLColorConstants;
import com.jaspersoft.studio.editor.xml.NonRuleBasedDamagerRepairer;
import com.jaspersoft.studio.editor.xml.XMLDoubleClickStrategy;
import com.jaspersoft.studio.editor.xml.contentassist.TagContentAssistProcessor;
import com.jaspersoft.studio.editor.xml.format.DefaultFormattingStrategy;
import com.jaspersoft.studio.editor.xml.format.DocTypeFormattingStrategy;
import com.jaspersoft.studio.editor.xml.format.PIFormattingStrategy;
import com.jaspersoft.studio.editor.xml.format.TextFormattingStrategy;
import com.jaspersoft.studio.editor.xml.format.XMLFormattingStrategy;
import com.jaspersoft.studio.editor.xml.scanners.CDataScanner;
import com.jaspersoft.studio.editor.xml.scanners.XMLScanner;
import com.jaspersoft.studio.editor.xml.scanners.XMLTagScanner;
import com.jaspersoft.studio.editor.xml.scanners.XMLTextScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.wb.swt.ColorManager;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private XMLTextScanner textScanner;
    private CDataScanner cdataScanner;
    private ColorManager colorManager;

    public XMLConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_pi", "__xml_doctype", "__xml_start_tag", "__xml_end_tag", "__xml_text"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTextScanner getXMLTextScanner() {
        if (this.textScanner == null) {
            this.textScanner = new XMLTextScanner(this.colorManager);
            this.textScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.textScanner;
    }

    protected CDataScanner getCDataScanner() {
        if (this.cdataScanner == null) {
            this.cdataScanner = new CDataScanner(this.colorManager);
            this.cdataScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.CDATA_TEXT))));
        }
        return this.cdataScanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_start_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_start_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_end_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_end_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_pi");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_pi");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_text");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_text");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCDataScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_cdata");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_cdata");
        TextAttribute textAttribute = new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT));
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(textAttribute);
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new TagContentAssistProcessor(this.getXMLTagScanner()), "__xml_start_tag");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        XMLFormattingStrategy formattingStrategy = new XMLFormattingStrategy();
        DefaultFormattingStrategy defaultStrategy = new DefaultFormattingStrategy();
        TextFormattingStrategy textStrategy = new TextFormattingStrategy();
        DocTypeFormattingStrategy doctypeStrategy = new DocTypeFormattingStrategy();
        PIFormattingStrategy piStrategy = new PIFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)defaultStrategy, "__dftl_partition_content_type");
        formatter.setFormattingStrategy((IFormattingStrategy)textStrategy, "__xml_text");
        formatter.setFormattingStrategy((IFormattingStrategy)doctypeStrategy, "__xml_doctype");
        formatter.setFormattingStrategy((IFormattingStrategy)piStrategy, "__xml_pi");
        formatter.setFormattingStrategy((IFormattingStrategy)textStrategy, "__xml_cdata");
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__xml_start_tag");
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__xml_end_tag");
        return formatter;
    }
}

