/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml;

import com.jaspersoft.studio.editor.xml.XMLPartitioner;
import com.jaspersoft.studio.editor.xml.scanners.XMLPartitionScanner;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class XMLDocumentProvider
extends FileDocumentProvider {
    private JasperReportsConfiguration jrContext;

    public XMLDocumentProvider(JasperReportsConfiguration jrContext) {
        this.jrContext = jrContext;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        block6: {
            InputStream stream = null;
            try {
                if (!(editorInput instanceof IFileEditorInput)) break block6;
                String fileExtention = JRXMLUtils.getFileExtension(editorInput);
                if (fileExtention != null && fileExtention.equals("jasper")) {
                    IFile file = ((IFileEditorInput)editorInput).getFile();
                    stream = file.getContents(false);
                    this.setDocumentContent(document, JRXMLUtils.getXML(this.jrContext, editorInput, encoding, stream, "last"), encoding);
                    break block6;
                }
                boolean bl = super.setDocumentContent(document, editorInput, encoding);
                return bl;
            }
            catch (JRException e) {
                e.printStackTrace();
            }
            finally {
                FileUtils.closeStream(stream);
            }
        }
        return true;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String fext = JRXMLUtils.getFileExtension((IEditorInput)element);
        if (fext != null && fext.equals("jasper")) {
            return;
        }
        if (element instanceof FileStoreEditorInput) {
            Charset charset;
            FileStoreEditorInput input = (FileStoreEditorInput)element;
            String encoding = null;
            try {
                charset = Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException ex) {
                String message = "unsuported encoding message";
                Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
            catch (IllegalCharsetNameException ex) {
                String message = "document provider error encoding";
                Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(new File(input.getURI().getPath()));
                    ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(document.get()));
                    if (byteBuffer.hasArray()) {
                        byte[] bytes = byteBuffer.array();
                    } else {
                        byte[] bytes = new byte[byteBuffer.limit()];
                        byteBuffer.get(bytes);
                    }
                    stream.write(byteBuffer.array());
                    stream.flush();
                }
                catch (CharacterCodingException ex) {
                    Assert.isTrue((boolean)(ex instanceof UnmappableCharacterException));
                    String message = "Error charset mapping";
                    Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
                    throw new CoreException((IStatus)s);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String message = "FileNotFoundException";
                    Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
                    throw new CoreException((IStatus)s);
                }
                catch (IOException iOException) {
                    String message = "IOException";
                    Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
                    throw new CoreException((IStatus)s);
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        String message = "IOException";
                        Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
                        throw new CoreException((IStatus)s);
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    String message = "IOException";
                    Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
                    throw new CoreException((IStatus)s);
                }
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }
}

