/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.xml.XMLConfiguration;
import com.jaspersoft.studio.editor.xml.XMLDocumentProvider;
import com.jaspersoft.studio.editor.xml.outline.EditorContentOutlinePage;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wb.swt.ColorManager;

public class XMLEditor
extends TextEditor {
    private ColorManager colorManager;
    private ActionRegistry actionRegistry = new ActionRegistry(){

        public IAction getAction(Object key) {
            return XMLEditor.this.getAction((String)key);
        }
    };
    private EditorContentOutlinePage outlinePage;

    public XMLEditor(JasperReportsConfiguration jrContext) {
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider(jrContext));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (XMLEditor.this.outlinePage != null) {
                    String text = XMLEditor.this.getSourceViewer().getTextWidget().getText();
                    try {
                        XMLEditor.this.outlinePage.setInput(text);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.outlinePage != null) {
            this.outlinePage.setInput(input);
        }
    }

    protected void editorSaved() {
        super.editorSaved();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = new NodeIconDescriptor("").getResourceBundle((AbstractUIPlugin)JaspersoftStudioPlugin.getInstance());
        this.setAction("ContentFormatProposal", (IAction)new TextOperationAction(bundle, "ContentFormatProposal.", (ITextEditor)this, 15));
        this.setAction("ContentAssistProposal", (IAction)new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13));
        this.setAction("ContentAssistTip", (IAction)new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14));
    }

    public void dispose() {
        this.colorManager.dispose();
        if (this.outlinePage != null) {
            this.outlinePage.setInput(null);
        }
        super.dispose();
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.getOutlineView();
        }
        return super.getAdapter(adapter);
    }

    protected IContentOutlinePage getOutlineView() {
        if (this.outlinePage == null) {
            this.outlinePage = new EditorContentOutlinePage((ITextEditor)this);
            if (this.getEditorInput() != null) {
                this.outlinePage.setInput(this.getEditorInput());
            }
        }
        return this.outlinePage;
    }

    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    protected void installEncodingSupport() {
        super.installEncodingSupport();
        this.fEncodingSupport.setEncoding("UTF-8");
    }
}

