/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml.contentassist;

import com.jaspersoft.studio.editor.xml.scanners.XMLTagScanner;
import com.jaspersoft.studio.editor.xml.xml.XMLElement;
import com.jaspersoft.studio.editor.xml.xml.XMLTree;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TagContentAssistProcessor
implements IContentAssistProcessor {
    XMLTree dtdTree = new XMLTree();
    private XMLTagScanner scanner;

    public TagContentAssistProcessor(XMLTagScanner scanner) {
        this.scanner = scanner;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        boolean isAttribute = this.isAttribute(offset, document);
        TextInfo currentText = this.currentText(document, offset);
        if (!isAttribute) {
            List<XMLElement> allElements = this.dtdTree.getAllElements();
            ICompletionProposal[] result = new ICompletionProposal[allElements.size()];
            int i = 0;
            for (XMLElement element : allElements) {
                String name = element.getName();
                String text = null;
                text = this.useContractedElementCompletion(offset, document) ? name : name + ">" + "</" + name + ">";
                result[i++] = new CompletionProposal(text, currentText.documentOffset, currentText.text.length(), text.length());
            }
            return result;
        }
        List<String> allAttributes = this.dtdTree.getAllAttributes();
        ICompletionProposal[] result = new ICompletionProposal[allAttributes.size()];
        int i = 0;
        for (String text : allAttributes) {
            if (currentText.isWhiteSpace) {
                text = String.valueOf(text) + "= \"\" ";
            }
            result[i++] = new CompletionProposal(text, currentText.documentOffset, currentText.text.length(), text.length());
        }
        return result;
    }

    private TextInfo currentText(IDocument document, int documentOffset) {
        try {
            ITypedRegion region = document.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int partitionLength = region.getLength();
            int index = documentOffset - partitionOffset;
            String partitionText = document.get(partitionOffset, partitionLength);
            char c = partitionText.charAt(index);
            if (Character.isWhitespace(c) || Character.isWhitespace(partitionText.charAt(index - 1))) {
                return new TextInfo("", documentOffset, true);
            }
            if (c == '<') {
                return new TextInfo("", documentOffset, true);
            }
            int start = index;
            c = partitionText.charAt(start);
            while (!Character.isWhitespace(c) && c != '<' && start >= 0) {
                c = partitionText.charAt(--start);
            }
            ++start;
            int end = index;
            c = partitionText.charAt(end);
            while (!Character.isWhitespace(c) && c != '>' && end < partitionLength - 1) {
                c = partitionText.charAt(++end);
            }
            String substring = partitionText.substring(start, end);
            return new TextInfo(substring, partitionOffset + start, false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isAttribute(int documentOffset, IDocument document) {
        boolean isAttribute = false;
        try {
            ITypedRegion region = document.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int readLength = documentOffset - partitionOffset;
            this.scanner.setRange(document, partitionOffset, readLength);
            boolean textReached = false;
            IToken token = null;
            while ((token = this.scanner.nextToken()) != Token.EOF) {
                if (token.getData() instanceof TextAttribute) {
                    textReached = true;
                    continue;
                }
                if (!textReached || !token.isWhitespace()) continue;
                isAttribute = true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return isAttribute;
    }

    private boolean useContractedElementCompletion(int documentOffset, IDocument document) {
        int remainingLength;
        boolean isRemainingWhiteSpace;
        boolean textReached;
        block8: {
            String firstTwo;
            textReached = false;
            isRemainingWhiteSpace = true;
            ITypedRegion region = document.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int partitionLength = region.getLength();
            int readLength = documentOffset - partitionOffset;
            remainingLength = partitionLength - readLength;
            if (document.getLength() < documentOffset + 1 || !(firstTwo = document.get(partitionOffset, 2)).equals("<<")) break block8;
            return false;
        }
        try {
            this.scanner.setRange(document, documentOffset, remainingLength);
            IToken token = null;
            while ((token = this.scanner.nextToken()) != Token.WHITESPACE && token != Token.EOF) {
                isRemainingWhiteSpace = false;
            }
            while ((token = this.scanner.nextToken()) == Token.WHITESPACE && token != Token.EOF) {
                isRemainingWhiteSpace = true;
            }
            char c = '\u0000';
            while (c == this.scanner.read()) {
                if (c != '\uffffffff' && c != '<') {
                    if (Character.isWhitespace(c)) continue;
                    textReached = true;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (textReached) {
            return true;
        }
        return !isRemainingWhiteSpace && !textReached;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    static class TextInfo {
        String text;
        boolean isWhiteSpace;
        int documentOffset;

        TextInfo(String text, int documentOffset, boolean isWhiteSpace) {
            this.text = text;
            this.isWhiteSpace = isWhiteSpace;
            this.documentOffset = documentOffset;
        }
    }
}

