/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XMLTextPredicateRule
implements IPredicateRule {
    private IToken token;
    private int charsRead;
    private boolean whiteSpaceOnly;
    boolean inCdata;

    public XMLTextPredicateRule(IToken text) {
        this.token = text;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        this.reinit();
        int c = 0;
        while (this.isOK(c = this.read(scanner), scanner)) {
            if (c == -1) {
                return Token.UNDEFINED;
            }
            boolean bl = this.whiteSpaceOnly = this.whiteSpaceOnly && Character.isWhitespace((char)c);
        }
        this.unread(scanner);
        if (this.whiteSpaceOnly) {
            this.rewind(scanner, this.charsRead);
            return Token.UNDEFINED;
        }
        return this.token;
    }

    private boolean isOK(int cc, ICharacterScanner scanner) {
        char c = (char)cc;
        if (!this.inCdata) {
            if (c == '<') {
                int cdataCharsRead = 0;
                int i = 0;
                while (i < "![CDATA[".length()) {
                    c = (char)this.read(scanner);
                    ++cdataCharsRead;
                    if (c != "![CDATA[".charAt(i)) {
                        this.rewind(scanner, cdataCharsRead);
                        this.inCdata = false;
                        return false;
                    }
                    ++i;
                }
                this.inCdata = true;
                return true;
            }
        } else if (c == ']') {
            int i = 0;
            while (i < "]>".length()) {
                c = (char)this.read(scanner);
                if (c != "]>".charAt(i)) {
                    return true;
                }
                ++i;
            }
            this.inCdata = false;
            return true;
        }
        return true;
    }

    private void rewind(ICharacterScanner scanner, int theCharsRead) {
        while (theCharsRead > 0) {
            --theCharsRead;
            this.unread(scanner);
        }
    }

    private void unread(ICharacterScanner scanner) {
        scanner.unread();
        --this.charsRead;
    }

    private int read(ICharacterScanner scanner) {
        int c = scanner.read();
        ++this.charsRead;
        return c;
    }

    private void reinit() {
        this.charsRead = 0;
        this.whiteSpaceOnly = true;
    }
}

