/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.font;

import java.util.Iterator;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class FontExtensionNewWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private ContainerSelectionGroup cmp;

    public FontExtensionNewWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle("Fonts Extension");
        this.setDescription("Select fonts selection file location");
    }

    public void createControl(Composite parent) {
        this.cmp = new ContainerSelectionGroup(parent, event -> {
            String msg = this.validate();
            this.setErrorMessage(msg);
            this.setPageComplete(msg == null);
        }, false, "Font Extension", false);
        this.initialPopulateContainerNameField();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)this.cmp);
    }

    private String validate() {
        this.setMessage(this.getDescription());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource folder = workspace.getRoot().findMember(this.cmp.getContainerFullPath());
        if (folder == null) {
            return null;
        }
        if (!folder.exists() || folder.isVirtual()) {
            return "You have to select only folders.";
        }
        return null;
    }

    protected void initialPopulateContainerNameField() {
        IResource selectedResource;
        Iterator it;
        if (this.selection != null && (it = this.selection.iterator()).hasNext() && (selectedResource = (IResource)Adapters.adapt(it.next(), IResource.class)) != null) {
            IResource initial;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource.isAccessible() && (initial = ResourcesPlugin.getWorkspace().getRoot().findMember(selectedResource.getFullPath())) != null) {
                if (!(initial instanceof IContainer)) {
                    initial = initial.getParent();
                }
                this.cmp.setSelectedContainer((IContainer)initial);
            }
        }
        UIUtils.getDisplay().asyncExec(() -> {
            String msg = this.validate();
            this.setErrorMessage(msg);
            this.setPageComplete(msg == null);
        });
    }

    public IPath getContainerFullPath() {
        return this.cmp.getContainerFullPath();
    }
}

