/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class EqualsVSpaceAction
extends AbstractFormattingAction {
    public static final String ID = "samevspace";

    public EqualsVSpaceAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EqualsVSpaceAction_actionName);
        this.setToolTipText(Messages.EqualsVSpaceAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/elem_add_vspace.png"));
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 1;
    }

    public static JSSCompoundCommand generateCommand(List<APropertyNode> nodes) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        if (nodes.isEmpty()) {
            return command;
        }
        List<APropertyNode> sortedElements = EqualsVSpaceAction.sortYX(nodes);
        int gap = 0;
        int usedSpace = 0;
        JRDesignElement jrElement = (JRDesignElement)sortedElements.get(0).getValue();
        command.setReferenceNodeIfNull(sortedElements.get(0));
        int minY = jrElement.getY();
        int maxY = minY + jrElement.getHeight();
        for (APropertyNode element : sortedElements) {
            jrElement = (JRDesignElement)element.getValue();
            if (minY > jrElement.getY()) {
                minY = jrElement.getY();
            }
            if (maxY < jrElement.getY() + jrElement.getHeight()) {
                maxY = jrElement.getY() + jrElement.getHeight();
            }
            usedSpace += jrElement.getHeight();
        }
        gap = (maxY - minY - usedSpace) / (nodes.size() - 1);
        int actualY = minY;
        int i = 0;
        while (i < sortedElements.size()) {
            APropertyNode element = sortedElements.get(i);
            jrElement = (JRDesignElement)element.getValue();
            if (i == 0) {
                actualY = jrElement.getY() + jrElement.getHeight() + gap;
            } else {
                int newY;
                SetValueCommand setCommand;
                if (i == sortedElements.size() - 1) {
                    setCommand = new SetValueCommand();
                    setCommand.setTarget(element);
                    setCommand.setPropertyId("y");
                    newY = maxY - jrElement.getHeight();
                    setCommand.setPropertyValue(newY);
                    command.add(setCommand);
                } else {
                    setCommand = new SetValueCommand();
                    setCommand.setTarget(element);
                    setCommand.setPropertyId("y");
                    newY = actualY;
                    setCommand.setPropertyValue(newY);
                    command.add(setCommand);
                }
                actualY = newY + jrElement.getHeight() + gap;
            }
            ++i;
        }
        return command;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = null;
        if (!nodes.isEmpty()) {
            command = EqualsVSpaceAction.generateCommand(nodes);
            command.setDebugLabel(this.getText());
        }
        return command;
    }
}

