/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class JoinRightAction
extends AbstractFormattingAction {
    public static final String ID = "joinright";

    public JoinRightAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.JoinRightAction_actionName);
        this.setToolTipText(Messages.JoinRightAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/joinright.png"));
    }

    public static JSSCompoundCommand generateCommand(List<APropertyNode> nodes) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        if (nodes.isEmpty()) {
            return command;
        }
        List<APropertyNode> sortedElements = JoinRightAction.sortXY(nodes, true);
        JRDesignElement jrElement = (JRDesignElement)sortedElements.get(0).getValue();
        int actualX = jrElement.getX() + jrElement.getWidth();
        for (APropertyNode element : sortedElements) {
            command.setReferenceNodeIfNull(element);
            jrElement = (JRDesignElement)element.getValue();
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(element);
            setCommand.setPropertyId("x");
            setCommand.setPropertyValue(actualX -= jrElement.getWidth());
            command.add(setCommand);
        }
        return command;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = null;
        if (!nodes.isEmpty()) {
            command = JoinRightAction.generateCommand(nodes);
            command.setDebugLabel(this.getText());
        }
        return command;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 1;
    }
}

