/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.handlers;

import com.jaspersoft.studio.handlers.TemplateExporterWizard;
import com.jaspersoft.studio.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportAsTemplateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TemplateExporterWizard wizard = new TemplateExporterWizard();
        wizard.init(this.getActiveWorkbench(event), this.getActiveSelection(event));
        if (wizard.canOpen()) {
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            int exitCode = dialog.open();
            if (exitCode != 1) {
                MessageBox messageBox = new MessageBox(UIUtils.getShell(), 34);
                messageBox.setText(Messages.ExportAsTemplateHandler_successTitle);
                messageBox.setMessage(String.valueOf(Messages.ExportAsTemplateHandler_successMessage) + wizard.getPath());
                messageBox.open();
            }
        } else {
            MessageBox messageBox = new MessageBox(UIUtils.getShell(), 40);
            messageBox.setText(Messages.ExportAsTemplateHandler_errorTitle);
            messageBox.setMessage(Messages.ExportAsTemplateHandler_errorMessage);
            messageBox.open();
        }
        return null;
    }

    private IStructuredSelection getActiveSelection(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            Object[] objectArray = ((IStructuredSelection)currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!(o instanceof IFile)) {
                    return StructuredSelection.EMPTY;
                }
                ++n2;
            }
            return (IStructuredSelection)currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    private IWorkbench getActiveWorkbench(ExecutionEvent event) {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbench activeWorkbench = PlatformUI.getWorkbench();
        if (activeWorkbenchWindow != null) {
            activeWorkbench = activeWorkbenchWindow.getWorkbench();
        }
        return activeWorkbench;
    }
}

