/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.jasper.CachedImageProvider;
import com.jaspersoft.studio.jasper.ConvertChartContext;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.chartthemes.simple.FileImageProvider;
import net.sf.jasperreports.chartthemes.simple.ImageProvider;
import net.sf.jasperreports.chartthemes.simple.SimpleChartTheme;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.Renderable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeListener;

public final class ChartConverter
extends ElementConverter {
    private static final ChartConverter INSTANCE = new ChartConverter();
    private JFreeChart jfreeChart;
    private Dataset dataset;

    private ChartConverter() {
    }

    public static ChartConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRChart chart = (JRChart)element;
        this.copyElement(reportConverter, (JRElement)chart, (JRPrintElement)printImage);
        printImage.copyBox(chart.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText((JRExpression)chart.getAnchorNameExpression()));
        String ble = JRExpressionUtil.getExpressionText((JRExpression)chart.getBookmarkLevelExpression());
        printImage.setBookmarkLevel(ble != null ? Integer.valueOf(ble).intValue() : chart.getBookmarkLevel());
        printImage.setLinkType(chart.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setRenderer(this.getRenderer(reportConverter, chart));
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        return printImage;
    }

    private ImageProvider getCachedImageProvider(ImageProvider ip) {
        if (ip != null) {
            try {
                if (ip instanceof CachedImageProvider) {
                    return ip;
                }
                if (ip instanceof FileImageProvider) {
                    return new CachedImageProvider((FileImageProvider)ip);
                }
                return ip;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Renderable getRenderer(ReportConverter reportConverter, JRChart chart) {
        JasperReportsConfiguration jContext = (JasperReportsConfiguration)reportConverter.getJasperReportsContext();
        String renderType = null;
        Rectangle2D.Double rectangle = null;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ChartTheme theme;
            String themeName;
            Thread.currentThread().setContextClassLoader(jContext.getClassLoader());
            if (this.dataset != null && this.jfreeChart != null) {
                this.dataset.removeChangeListener((DatasetChangeListener)this.jfreeChart.getPlot());
            }
            if ((renderType = chart.getRenderType()) == null) {
                renderType = JRPropertiesUtil.getInstance((JasperReportsContext)jContext).getProperty((JRPropertiesHolder)reportConverter.getReport(), "net.sf.jasperreports.chart.render.type");
            }
            if ((themeName = chart.getTheme()) == null) {
                themeName = JRPropertiesUtil.getInstance((JasperReportsContext)jContext).getProperty((JRPropertiesHolder)reportConverter.getReport(), "net.sf.jasperreports.chart.theme");
            }
            if ((theme = ChartUtil.getInstance((JasperReportsContext)jContext).getTheme(themeName)) instanceof SimpleChartTheme) {
                SimpleChartTheme sct = (SimpleChartTheme)theme;
                sct.getChartSettings().setBackgroundImage(this.getCachedImageProvider(sct.getChartSettings().getBackgroundImage()));
                sct.getPlotSettings().setBackgroundImage(this.getCachedImageProvider(sct.getPlotSettings().getBackgroundImage()));
            }
            ConvertChartContext chartContext = null;
            chartContext = new ConvertChartContext(chart, (JasperReportsContext)jContext);
            try {
                this.jfreeChart = theme.createChart((ChartContext)chartContext);
                this.dataset = chartContext.getDataset();
                if (this.jfreeChart == null && chart.getChartType() == 19) {
                    List axis = ((JRDesignMultiAxisPlot)chart.getPlot()).getAxes();
                    Plot mainPlot = null;
                    int axisNumber = 0;
                    for (JRChartAxis ax : axis) {
                        CategoryPlot axisPlot;
                        JRChart chartAxis = ((JRDesignChartAxis)ax).getChart();
                        if (this.jfreeChart == null) {
                            this.jfreeChart = this.getJFreeChart(reportConverter, chartAxis);
                            mainPlot = this.jfreeChart.getPlot();
                            if (mainPlot instanceof CategoryPlot) {
                                ((CategoryPlot)mainPlot).setRangeAxisLocation(0, this.getChartAxisLocation(ax));
                                continue;
                            }
                            if (!(mainPlot instanceof XYPlot)) continue;
                            ((XYPlot)mainPlot).setRangeAxisLocation(0, this.getChartAxisLocation(ax));
                            continue;
                        }
                        ++axisNumber;
                        JFreeChart axisChart = this.getJFreeChart(reportConverter, chartAxis);
                        if (mainPlot instanceof CategoryPlot) {
                            CategoryPlot mainCatPlot = (CategoryPlot)mainPlot;
                            if (!(axisChart.getPlot() instanceof CategoryPlot)) continue;
                            axisPlot = (CategoryPlot)axisChart.getPlot();
                            mainCatPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                            mainCatPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(ax));
                            mainCatPlot.setDataset(axisNumber, axisPlot.getDataset());
                            mainCatPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                            mainCatPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                            this.configureAxisSeriesColors(axisPlot.getRenderer(), chartAxis.getPlot());
                            continue;
                        }
                        if (!(mainPlot instanceof XYPlot)) continue;
                        XYPlot mainXyPlot = (XYPlot)mainPlot;
                        if (!(axisChart.getPlot() instanceof XYPlot)) continue;
                        axisPlot = (XYPlot)axisChart.getPlot();
                        mainXyPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                        mainXyPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(ax));
                        mainXyPlot.setDataset(axisNumber, axisPlot.getDataset());
                        mainXyPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                        mainXyPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                        this.configureAxisSeriesColors(axisPlot.getRenderer(), chartAxis.getPlot());
                    }
                }
            }
            catch (JRException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            rectangle = new Rectangle2D.Double(0.0, 0.0, chart.getWidth(), chart.getHeight());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return ChartUtil.getInstance((JasperReportsContext)jContext).getChartRenderableFactory(renderType).getRenderable((JasperReportsContext)jContext, this.jfreeChart, null, (Rectangle2D)rectangle);
    }

    private JFreeChart getJFreeChart(ReportConverter reportConverter, JRChart chart) {
        JasperReportsContext jContext = reportConverter.getJasperReportsContext();
        String themeName = chart.getTheme();
        if (themeName == null) {
            themeName = JRPropertiesUtil.getInstance((JasperReportsContext)jContext).getProperty((JRPropertiesHolder)reportConverter.getReport(), "net.sf.jasperreports.chart.theme");
        }
        ChartTheme theme = ChartUtil.getInstance((JasperReportsContext)jContext).getTheme(themeName);
        ConvertChartContext chartContext = new ConvertChartContext(chart, jContext);
        JFreeChart jfreeChart = null;
        try {
            jfreeChart = theme.createChart((ChartContext)chartContext);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis ca) {
        AxisPositionEnum pv = ca.getPositionValue();
        return ca.getPositionValue() != null && pv == AxisPositionEnum.RIGHT_OR_BOTTOM ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    private void configureAxisSeriesColors(CategoryItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }
}

