/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.editor.AMultiEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.CacheMap;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintGraphicElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class ImageConverter
extends ElementConverter {
    private static final Log log = LogFactory.getLog(ImageConverter.class);
    private static final ImageConverter INSTANCE = new ImageConverter();
    private CacheMap<JRElement, Renderable> cache = new CacheMap(3000000);
    private CacheMap<JRElement, KeyValue<String, Long>> running = new CacheMap(3000000);
    private static CacheMap<KeyValue<JasperReportsContext, String>, Renderable> imgCache = new CacheMap(10000);
    private static Renderable noImage;

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRImage image = (JRImage)element;
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        Renderable cacheRenderer = this.getRenderable(reportConverter, element, image, printImage);
        this.copyGraphicElement(reportConverter, (JRGraphicElement)image, (JRBasePrintGraphicElement)printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText((JRExpression)image.getAnchorNameExpression()));
        String ble = JRExpressionUtil.getExpressionText((JRExpression)image.getBookmarkLevelExpression());
        printImage.setBookmarkLevel(ble != null ? Integer.valueOf(ble).intValue() : image.getBookmarkLevel());
        printImage.setHorizontalImageAlign(image.getOwnHorizontalImageAlign());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setVerticalImageAlign(image.getOwnVerticalImageAlign());
        if (cacheRenderer == null) {
            cacheRenderer = this.getRenderableNoImage(reportConverter.getJasperReportsContext(), image, (JRPrintImage)printImage);
        }
        printImage.setRenderer(cacheRenderer);
        printImage.setScaleImage(image.getOwnScaleImageValue());
        return printImage;
    }

    protected Renderable getRenderable(ReportConverter reportConverter, JRElement element, JRImage image, JRBasePrintImage printImage) {
        Renderable cacheRenderer = null;
        try {
            cacheRenderer = this.cache.get(element);
            if (image.getExpression() != null) {
                String expr = image.getExpression().getText();
                KeyValue<String, Long> last = this.running.get(element);
                Renderable r = null;
                if (cacheRenderer == null) {
                    cacheRenderer = this.getRenderableNoImage(reportConverter.getJasperReportsContext(), image, (JRPrintImage)printImage);
                    this.cache.put(element, cacheRenderer);
                    if (last == null) {
                        r = this.doFindImage(reportConverter, element, image, printImage, expr, cacheRenderer);
                    }
                }
                if (last != null && (!((String)last.key).equals(expr) || last.value != null && System.currentTimeMillis() - (Long)last.value > 2000L)) {
                    r = this.doFindImage(reportConverter, element, image, printImage, expr, cacheRenderer);
                }
                if (last == null) {
                    r = this.doFindImage(reportConverter, element, image, printImage, expr, cacheRenderer);
                }
                if (r != null) {
                    cacheRenderer = r;
                }
            } else {
                this.running.remove(element);
                cacheRenderer = this.getRenderableNoImage(reportConverter.getJasperReportsContext(), image, (JRPrintImage)printImage);
                this.cache.put(element, cacheRenderer);
            }
        }
        catch (Throwable throwable) {
            return this.getRenderableNoImage(reportConverter.getJasperReportsContext(), image, (JRPrintImage)printImage);
        }
        return cacheRenderer;
    }

    protected Renderable doFindImage(ReportConverter reportConverter, final JRElement element, final JRImage image, final JRBasePrintImage printImage, final String expr, Renderable cacheRenderer) {
        final JasperReportsContext jrContext = reportConverter.getJasperReportsContext();
        final KeyValue key = new KeyValue((Object)jrContext, (Object)expr);
        Renderable r = imgCache.get(key);
        if (r != null) {
            this.cache.put(element, r);
            return r;
        }
        imgCache.put((KeyValue<JasperReportsContext, String>)key, cacheRenderer);
        final KeyValue kv = new KeyValue((Object)expr, null);
        this.running.put(element, (KeyValue<String, Long>)kv);
        Job job = new Job(Messages.ImageConverter_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final Renderable r = ImageConverter.this.getRenderable(jrContext, image, (JRPrintImage)printImage, (KeyValue<JasperReportsContext, String>)key);
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ImageConverter.this.cache.put(element, r);
                            kv.value = System.currentTimeMillis();
                            PropertyChangeEvent event = new PropertyChangeEvent(image, "expression", null, expr);
                            AMultiEditor.refreshElement(jrContext, event);
                        }
                    });
                    HashSet set = new HashSet();
                    for (KeyValue k : set) {
                        imgCache.get(k);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    private Renderable getRenderable(JasperReportsContext jasperReportsContext, JRImage imageElement, JRPrintImage printImage, KeyValue<JasperReportsContext, String> key) {
        Renderable r;
        block4: {
            r = null;
            String location = ExpressionUtil.cachedExpressionEvaluationString(imageElement.getExpression(), (JasperReportsConfiguration)jasperReportsContext);
            if (location != null) {
                try {
                    r = RendererUtil.getInstance((JasperReportsContext)jasperReportsContext).getNonLazyRenderable(location, OnErrorTypeEnum.ERROR);
                    imgCache.put(key, r);
                }
                catch (JRException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)Messages.ImageConverter_1, (Throwable)e);
                }
            }
        }
        if (r == null) {
            r = this.getRenderableNoImage(jasperReportsContext, imageElement, printImage);
        }
        return r;
    }

    private Renderable getRenderableNoImage(JasperReportsContext jasperReportsContext, JRImage imageElement, JRPrintImage printImage) {
        block3: {
            try {
                printImage.setScaleImage(ScaleImageEnum.CLIP);
                if (noImage == null) {
                    noImage = RendererUtil.getInstance((JasperReportsContext)jasperReportsContext).getNonLazyRenderable("net/sf/jasperreports/engine/images/image-16.png", imageElement.getOnErrorTypeValue());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)Messages.ImageConverter_1, (Throwable)e);
            }
        }
        return noImage;
    }
}

