/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JSSTextDrawer
extends TextDrawer {
    public JSSTextDrawer(JasperReportsContext jasperReportsContext, AwtTextRenderer textRenderer) {
        super(jasperReportsContext, textRenderer);
    }

    public void draw(Graphics2D grx, JRPrintText text, int offsetX, int offsetY) {
        String allText;
        this.textRenderer.initialize(grx, text, offsetX, offsetY);
        JRStyledText styledText = this.textRenderer.getStyledText();
        if (styledText == null) {
            return;
        }
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                angle = -1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = 1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
            }
        }
        grx.rotate(angle, this.textRenderer.getX(), this.textRenderer.getY());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(this.textRenderer.getX(), this.textRenderer.getY(), this.textRenderer.getWidth(), this.textRenderer.getHeight());
        }
        if ((allText = this.textRenderer.getPlainText()).length() > 0) {
            grx.setColor(text.getForecolor());
            this.textRenderer.render();
        }
        grx.rotate(-angle, this.textRenderer.getX(), this.textRenderer.getY());
        this.drawBox(grx, text.getLineBox(), (JRPrintElement)text, offsetX, offsetY);
    }
}

