/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintGraphicElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class LazyImageConverter
extends ElementConverter {
    protected static HashMap<String, Renderable> fixedImageCache = new HashMap();
    public static long imageRefreshTime;
    private HashMap<KeyValue<JasperReportsContext, String>, TimedCache> imgCache = new HashMap();
    private HashMap<KeyValue<JasperReportsContext, String>, HashSet<MGraphicElement>> pendingRequests = new HashMap();
    private HashSet<KeyValue<JasperReportsContext, String>> notEvaluableExpressions = new HashSet();
    private static final LazyImageConverter INSTANCE;

    static {
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/white-transparent-pixel.png");
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/image-16.png");
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/subreport-16.png");
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/chart-16.png");
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/crosstab-16.png");
        LazyImageConverter.loadFixedImage("net/sf/jasperreports/engine/images/component-16.png");
        imageRefreshTime = -1L;
        INSTANCE = new LazyImageConverter();
    }

    private static void loadFixedImage(String path) {
        try {
            Renderable renderable = RendererUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getNonLazyRenderable(path, OnErrorTypeEnum.BLANK);
            if (renderable != null) {
                fixedImageCache.put(path, renderable);
            }
        }
        catch (Exception exception) {}
    }

    protected LazyImageConverter() {
    }

    public static LazyImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        return null;
    }

    public JRPrintElement convertImage(ReportConverter reportConverter, MGraphicElement element) {
        JRImage image = (JRImage)element.getValue();
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        Renderable cacheRenderer = this.getRenderable(reportConverter, image, element);
        this.copyGraphicElement(reportConverter, (JRGraphicElement)image, (JRBasePrintGraphicElement)printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText((JRExpression)image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalImageAlign(image.getOwnHorizontalImageAlign());
        printImage.setLinkType(image.getLinkType());
        printImage.setRotation(image.getRotation());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setVerticalImageAlign(image.getOwnVerticalImageAlign());
        if (cacheRenderer == null) {
            cacheRenderer = this.getRenderableNoImage(reportConverter.getJasperReportsContext(), image, (JRPrintImage)printImage);
        }
        printImage.setRenderer(cacheRenderer);
        printImage.setScaleImage(image.getOwnScaleImageValue());
        return printImage;
    }

    private Renderable getRenderable(ReportConverter reportConverter, JRImage image, MGraphicElement modelElement) {
        JasperReportsContext jrContext = reportConverter.getJasperReportsContext();
        JRExpression expr = image.getExpression();
        if (expr != null && !this.notEvaluableExpressions.contains(this.getExpressionKey(jrContext, expr))) {
            KeyValue<JasperReportsContext, String> key = this.getKey(jrContext, modelElement, expr);
            if (!((String)key.value).isEmpty()) {
                TimedCache imageInfo = this.getImageInfo(key);
                if (imageInfo.isExpired()) {
                    this.refreshImageInfo(imageInfo, modelElement, (String)key.value, jrContext, key);
                }
                return imageInfo.getImage();
            }
            this.notEvaluableExpressions.add(this.getExpressionKey(jrContext, expr));
        }
        return null;
    }

    protected TimedCache getImageInfo(KeyValue<JasperReportsContext, String> key) {
        TimedCache imageInfo = this.imgCache.get(key);
        if (imageInfo == null) {
            imageInfo = new TimedCache();
            this.imgCache.put(key, imageInfo);
        }
        return imageInfo;
    }

    protected KeyValue<JasperReportsContext, String> getKey(JasperReportsContext jrContext, String location) {
        return new KeyValue((Object)jrContext, (Object)location);
    }

    protected KeyValue<JasperReportsContext, String> getExpressionKey(JasperReportsContext jrContext, JRExpression expression) {
        return new KeyValue((Object)jrContext, (Object)(expression != null ? expression.getText() : ""));
    }

    protected KeyValue<JasperReportsContext, String> getKey(JasperReportsContext jrContext, MGraphicElement modelElement, JRExpression expr) {
        JasperReportsConfiguration jConfig;
        String evaluatedExpr;
        if (expr != null && (evaluatedExpr = this.evaluatedExpression(jConfig = (JasperReportsConfiguration)jrContext, modelElement, expr)) != null) {
            return this.getKey(jrContext, evaluatedExpr);
        }
        return this.getKey(jrContext, "");
    }

    private String evaluatedExpression(JasperReportsConfiguration jConf, MGraphicElement modelElement, JRExpression expr) {
        JRDesignDataset jrd = ModelUtils.getFirstDatasetInHierarchy(modelElement);
        String expressionText = this.getExpressionText(expr);
        return ExpressionUtil.cachedExpressionEvaluationString((JRExpression)new JRDesignExpression(expressionText), jConf, jrd);
    }

    protected String getExpressionText(JRExpression styleExpression) {
        String expString = styleExpression != null ? styleExpression.getText() : "";
        String variableStaticPath = ExpressionUtil.extractValueForVariable("@path", expString);
        if (variableStaticPath != null) {
            return variableStaticPath;
        }
        return expString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImageInfo(TimedCache info, MGraphicElement modelElement, String location, JasperReportsContext jrContext, KeyValue<JasperReportsContext, String> key) {
        HashSet<MGraphicElement> resourceRequest = this.pendingRequests.get(key);
        if (resourceRequest == null) {
            resourceRequest = new HashSet();
            this.pendingRequests.put(key, resourceRequest);
        }
        HashSet<MGraphicElement> hashSet = resourceRequest;
        synchronized (hashSet) {
            if (resourceRequest.isEmpty()) {
                resourceRequest.add(modelElement);
                this.startLoadingJob(info, location, jrContext, key);
            } else {
                resourceRequest.add(modelElement);
            }
        }
    }

    private void startLoadingJob(final TimedCache info, final String location, final JasperReportsContext jrContext, final KeyValue<JasperReportsContext, String> key) {
        Job job = new Job("load image"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (location != null) {
                        IFile file = (IFile)((JasperReportsConfiguration)jrContext).get("ifile");
                        String reportPath = file.getParent().getLocation().toFile().getAbsolutePath();
                        SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)reportPath);
                        SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jrContext, (RepositoryResourceContext)context);
                        Renderable r = RendererUtil.getInstance((RepositoryContext)repoContext).getNonLazyRenderable(location, OnErrorTypeEnum.ERROR);
                        info.update(r);
                        LazyImageConverter.this.refreshElements((KeyValue<JasperReportsContext, String>)key);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshElements(KeyValue<JasperReportsContext, String> key) {
        HashSet<MGraphicElement> resourceRequest = this.pendingRequests.get(key);
        if (resourceRequest == null) {
            return;
        }
        HashSet<MGraphicElement> hashSet = resourceRequest;
        synchronized (hashSet) {
            if (resourceRequest != null) {
                for (final MGraphicElement refreshElement : resourceRequest) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            refreshElement.setChangedProperty(true);
                            refreshElement.getValue().getEventSupport().firePropertyChange(MGraphicElement.FORCE_GRAPHICAL_REFRESH, null, null);
                        }
                    });
                }
                resourceRequest.clear();
            }
        }
    }

    private Renderable getRenderableNoImage(JasperReportsContext jasperReportsContext, JRImage imageElement, JRPrintImage printImage) {
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        return fixedImageCache.get("net/sf/jasperreports/engine/images/image-16.png");
    }

    public void removeCachedImages(JasperReportsConfiguration jConfig) {
        for (KeyValue<JasperReportsContext, String> key : new ArrayList<KeyValue<JasperReportsContext, String>>(this.imgCache.keySet())) {
            if (key.key != jConfig) continue;
            this.imgCache.remove(key);
        }
        for (KeyValue<JasperReportsContext, String> key : new ArrayList<KeyValue<JasperReportsContext, String>>(this.notEvaluableExpressions)) {
            if (key.key != jConfig) continue;
            this.notEvaluableExpressions.remove(key);
        }
    }

    public void removeCachedImage(JasperReportsConfiguration jConfig, MImage imageModel) {
        JRDesignImage image = imageModel.getValue();
        JRExpression expr = image.getExpression();
        KeyValue<JasperReportsContext, String> exprKey = this.getExpressionKey((JasperReportsContext)jConfig, expr);
        this.notEvaluableExpressions.remove(exprKey);
        KeyValue<JasperReportsContext, String> key = this.getKey((JasperReportsContext)jConfig, imageModel, expr);
        this.imgCache.remove(key);
    }

    protected Renderable getNonLazyRenderable(JasperReportsContext jrContext, String location) {
        if (fixedImageCache.containsKey(location)) {
            return fixedImageCache.get(location);
        }
        KeyValue<JasperReportsContext, String> key = this.getKey(jrContext, location);
        TimedCache imageInfo = this.getImageInfo(key);
        if (imageInfo.isExpired()) {
            try {
                IFile file = (IFile)((JasperReportsConfiguration)jrContext).get("ifile");
                String reportPath = file.getParent().getLocation().toFile().getAbsolutePath();
                SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)reportPath);
                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jrContext, (RepositoryResourceContext)context);
                Renderable r = RendererUtil.getInstance((RepositoryContext)repoContext).getNonLazyRenderable(location, OnErrorTypeEnum.ERROR);
                imageInfo.update(r);
            }
            catch (JRException e) {
                try {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                    Renderable errorImage = RendererUtil.getInstance((JasperReportsContext)jrContext).handleImageError((Exception)((Object)e), OnErrorTypeEnum.ERROR);
                    imageInfo.update(errorImage);
                }
                catch (JRException jRException) {
                    imageInfo.update(RendererUtil.NO_IMAGE_RENDERER);
                }
            }
        }
        return imageInfo.getImage();
    }

    public Renderable getLazyRenderable(JasperReportsContext context, String location) {
        if (fixedImageCache.containsKey(location)) {
            return fixedImageCache.get(location);
        }
        KeyValue<JasperReportsContext, String> key = this.getKey(context, location);
        TimedCache imageInfo = this.getImageInfo(key);
        if (imageInfo.isExpired()) {
            this.startLoadingJob(imageInfo, location, context, key);
            imageInfo.update(fixedImageCache.get("net/sf/jasperreports/engine/images/image-16.png"));
        }
        return imageInfo.getImage();
    }

    private class TimedCache {
        private long newtime = System.currentTimeMillis();
        private long timeout = imageRefreshTime;
        private Renderable image;

        public TimedCache(Renderable image) {
            this.image = image;
        }

        public TimedCache() {
            this.image = null;
        }

        public void update(Renderable image) {
            this.image = image;
            this.newtime = System.currentTimeMillis();
        }

        public Renderable getImage() {
            return this.image;
        }

        public boolean isExpired() {
            long actualTime = System.currentTimeMillis();
            return this.image == null || actualTime - this.newtime > this.timeout && this.timeout != -1L;
        }
    }
}

