/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.UIUtil;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class DatasetRunPameterDialog
extends FormDialog
implements IExpressionContextSetter {
    private JRDesignDatasetParameter datasetParameter;
    private JRDesignDataset dataset;
    private Combo comboParameterName;
    private WTextExpression parameterExpression;
    private ExpressionContext expContext;

    public DatasetRunPameterDialog(JRDesignDatasetParameter datasetParameter, JRDesignDataset dataset, Shell parentShell) {
        super(parentShell);
        this.datasetParameter = datasetParameter;
        this.dataset = dataset;
    }

    protected void createFormContent(IManagedForm mform) {
        Composite container = mform.getForm().getBody();
        container.setBackground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_BACKGROUND"));
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginHeight = 10;
        containerLayout.verticalSpacing = 10;
        container.setLayout((Layout)containerLayout);
        Label lblParameterName = new Label(container, 0);
        lblParameterName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblParameterName.setText(Messages.DatasetRunPameterDialog_ParameterNameLbl);
        this.comboParameterName = new Combo(container, 8);
        this.comboParameterName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        JRParameter[] dsParameters = this.dataset.getParameters();
        String[] parameterNames = new String[dsParameters.length];
        int i = 0;
        while (i < dsParameters.length) {
            parameterNames[i] = dsParameters[i].getName();
            ++i;
        }
        this.comboParameterName.setItems(parameterNames);
        this.comboParameterName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = DatasetRunPameterDialog.this.comboParameterName.getSelectionIndex();
                if (selIndex >= 0) {
                    DatasetRunPameterDialog.this.datasetParameter.setName(DatasetRunPameterDialog.this.comboParameterName.getItem(selIndex));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblParameterExpression = new Label(container, 0);
        lblParameterExpression.setText(Messages.DatasetRunPameterDialog_ValueExprLbl);
        lblParameterExpression.setLayoutData((Object)new GridData(4, 4, false, false));
        this.parameterExpression = new WTextExpression(container, 0){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                DatasetRunPameterDialog.this.datasetParameter.setExpression((JRExpression)exp);
            }
        };
        this.parameterExpression.setLayoutData(new GridData(4, 4, true, true));
        this.parameterExpression.setExpressionContext(this.expContext);
        if (this.datasetParameter != null) {
            boolean found = false;
            int i2 = 0;
            while (i2 < parameterNames.length) {
                if (parameterNames[i2].equals(this.datasetParameter.getName())) {
                    this.comboParameterName.select(i2);
                    found = true;
                    break;
                }
                ++i2;
            }
            if (!found) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.DatasetRunPameterDialog_ParamNotFoundErrTitle, (String)MessageFormat.format(Messages.DatasetRunPameterDialog_ParamNotFoundErrMsg, this.datasetParameter.getName()));
            } else {
                this.parameterExpression.setExpression((JRDesignExpression)this.datasetParameter.getExpression());
            }
        } else {
            this.datasetParameter = new JRDesignDatasetParameter();
        }
    }

    protected Point getInitialSize() {
        return new Point(470, 250);
    }

    protected boolean isResizable() {
        return true;
    }

    public JRDesignDatasetParameter getModifiedDatasetParameter() {
        return this.datasetParameter;
    }

    protected void okPressed() {
        if (this.comboParameterName.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DatasetRunPameterDialog_NoParamSelectedErrTitle, (String)Messages.DatasetRunPameterDialog_NoParamSelectedErrMsg);
            return;
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DatasetRunPameterDialog_Title);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }
}

