/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.jface.IFileSelection;
import com.jaspersoft.studio.jface.dialogs.ISupportedTypes;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class FileSelectionDialog
extends PersistentLocationDialog
implements ISupportedTypes {
    public static final String ALL_FILES_TYPE = "*.*";
    protected String fileExpressionText;
    protected Text txtResourcePath;
    protected Text txtFilesystemPath;
    protected Text txtURL;
    protected Button btnWorkspaceResource;
    protected Button btnAbsolutePath;
    protected Button btnNoFile;
    protected Button btnUrlRemote;
    protected Button btnCustomExpression;
    protected StackLayout grpOptionsLayout;
    protected Composite cmpWorkspaceResourceSelection;
    protected Composite cmpFilesystemResourceSelection;
    protected Composite cmpNoFile;
    protected Composite cmpCustomExpression;
    protected Composite cmpURL;
    protected Group grpOptions;
    protected WTextExpression customExpression;
    protected JRDesignExpression jrFileExpression;
    protected JasperReportsConfiguration jConfig;
    protected boolean allowValidation = true;
    private List<IFileSelection> fselectors;
    protected Composite container;

    public FileSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected String getDialogTitle() {
        return Messages.FileSelectionDialog_0;
    }

    protected String[] getImageModesAndHeaderTitles() {
        return new String[]{Messages.FileSelectionDialog_1, Messages.FileSelectionDialog_2, Messages.FileSelectionDialog_3, Messages.FileSelectionDialog_4, Messages.FileSelectionDialog_5, Messages.FileSelectionDialog_6};
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.container = new Composite(area, 0);
        this.container.setLayout((Layout)new GridLayout(1, true));
        this.container.setLayoutData((Object)new GridData(1808));
        String[] fileModesAndHeaderTitles = this.getImageModesAndHeaderTitles();
        Group grpFileSelectionMode = new Group(this.container, 0);
        grpFileSelectionMode.setText(fileModesAndHeaderTitles[0]);
        grpFileSelectionMode.setLayout((Layout)new GridLayout(1, false));
        grpFileSelectionMode.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.btnWorkspaceResource = new Button((Composite)grpFileSelectionMode, 16);
        this.btnWorkspaceResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileSelectionDialog.this.btnWorkspaceResource.getSelection()) {
                    FileSelectionDialog.this.changeFileSelectionMode((Control)FileSelectionDialog.this.cmpWorkspaceResourceSelection);
                    FileSelectionDialog.this.allowValidation = true;
                }
            }
        });
        this.btnWorkspaceResource.setText(fileModesAndHeaderTitles[1]);
        this.btnAbsolutePath = new Button((Composite)grpFileSelectionMode, 16);
        this.btnAbsolutePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileSelectionDialog.this.btnAbsolutePath.getSelection()) {
                    FileSelectionDialog.this.changeFileSelectionMode((Control)FileSelectionDialog.this.cmpFilesystemResourceSelection);
                    FileSelectionDialog.this.allowValidation = true;
                }
            }
        });
        this.btnAbsolutePath.setText(fileModesAndHeaderTitles[2]);
        this.btnUrlRemote = new Button((Composite)grpFileSelectionMode, 16);
        this.btnUrlRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileSelectionDialog.this.btnUrlRemote.getSelection()) {
                    FileSelectionDialog.this.changeFileSelectionMode((Control)FileSelectionDialog.this.cmpURL);
                    FileSelectionDialog.this.allowValidation = true;
                }
            }
        });
        this.btnUrlRemote.setText(fileModesAndHeaderTitles[3]);
        this.fselectors = JaspersoftStudioPlugin.getExtensionManager().getFileSelectors();
        for (IFileSelection fs : this.fselectors) {
            fs.createRadioButton((Composite)grpFileSelectionMode, this, this.jConfig.getJasperDesign());
        }
        this.btnCustomExpression = new Button((Composite)grpFileSelectionMode, 16);
        this.btnCustomExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileSelectionDialog.this.btnCustomExpression.getSelection()) {
                    FileSelectionDialog.this.changeFileSelectionMode((Control)FileSelectionDialog.this.cmpCustomExpression);
                    FileSelectionDialog.this.allowValidation = false;
                }
            }
        });
        this.btnCustomExpression.setText(fileModesAndHeaderTitles[5]);
        if (this.allowNoFileOption()) {
            this.btnNoFile = new Button((Composite)grpFileSelectionMode, 16);
            this.btnNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FileSelectionDialog.this.btnNoFile.getSelection()) {
                        FileSelectionDialog.this.changeFileSelectionMode((Control)FileSelectionDialog.this.cmpNoFile);
                        FileSelectionDialog.this.allowValidation = false;
                    }
                }
            });
            this.btnNoFile.setText(fileModesAndHeaderTitles[4]);
            this.createOptionsPanel(this.container);
            this.btnNoFile.setSelection(true);
            this.btnNoFile.setFocus();
            this.allowValidation = false;
            this.changeFileSelectionMode((Control)this.cmpNoFile);
        } else {
            this.createOptionsPanel(this.container);
            this.btnWorkspaceResource.setSelection(true);
            this.allowValidation = true;
            this.btnWorkspaceResource.setFocus();
            this.changeFileSelectionMode((Control)this.cmpWorkspaceResourceSelection);
        }
        return area;
    }

    public boolean isValidationAllowed() {
        return this.allowValidation;
    }

    public void setAllowValidation(boolean value) {
        this.allowValidation = value;
    }

    private void createOptionsPanel(Composite container) {
        this.grpOptions = new Group(container, 0);
        this.grpOptions.setText(Messages.ImageSelectionDialog_OptionsGroupTitle);
        this.grpOptionsLayout = new StackLayout();
        this.grpOptions.setLayout((Layout)this.grpOptionsLayout);
        this.grpOptions.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.createWSSelectionContainer();
        this.createFSSelectionContainer();
        this.createNoFileContainer();
        this.createCustomExprContainer();
        this.createURLOptionsContainer();
        for (IFileSelection fs : this.fselectors) {
            fs.createFileSelectionContainer((Composite)this.grpOptions);
        }
    }

    private void createWSSelectionContainer() {
        this.cmpWorkspaceResourceSelection = new Composite((Composite)this.grpOptions, 0);
        this.cmpWorkspaceResourceSelection.setLayout((Layout)new GridLayout(2, false));
        Label lblSelectFileFromWS = new Label(this.cmpWorkspaceResourceSelection, 0);
        lblSelectFileFromWS.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblSelectFileFromWS.setText(Messages.ImageSelectionDialog_SelectImgFromWS);
        this.txtResourcePath = new Text(this.cmpWorkspaceResourceSelection, 2048);
        this.txtResourcePath.setEnabled(false);
        this.txtResourcePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnSelectWsRes = new Button(this.cmpWorkspaceResourceSelection, 0);
        btnSelectWsRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog.this.selectFileFromWorkspace();
            }
        });
        btnSelectWsRes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectWsRes.setText(Messages.ImageSelectionDialog_Browse);
    }

    private void createFSSelectionContainer() {
        this.cmpFilesystemResourceSelection = new Composite((Composite)this.grpOptions, 0);
        this.cmpFilesystemResourceSelection.setLayout((Layout)new GridLayout(2, false));
        Label lblSelectFileFromFilesystem = new Label(this.cmpFilesystemResourceSelection, 0);
        lblSelectFileFromFilesystem.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        lblSelectFileFromFilesystem.setText(Messages.ImageSelectionDialog_SelectImgFromFS);
        this.txtFilesystemPath = new Text(this.cmpFilesystemResourceSelection, 2048);
        this.txtFilesystemPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFilesystemPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSelectionDialog.this.handleTxtFilesystemPathChange();
            }
        });
        Button btnSelectFilesystemRes = new Button(this.cmpFilesystemResourceSelection, 0);
        btnSelectFilesystemRes.setText(Messages.ImageSelectionDialog_Browse);
        btnSelectFilesystemRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog.this.selectFileFromFilesystem();
            }
        });
    }

    public void handleTxtFilesystemPathChange() {
        this.fileExpressionText = this.getRootRelativePath(this.txtFilesystemPath.getText()).replace(System.getProperty("file.separator").charAt(0), '/');
    }

    private void createNoFileContainer() {
        this.cmpNoFile = new Composite((Composite)this.grpOptions, 0);
    }

    private void createCustomExprContainer() {
        this.cmpCustomExpression = new Composite((Composite)this.grpOptions, 0);
        GridLayout cmpCustomExpressionlayout = new GridLayout();
        this.cmpCustomExpression.setLayout((Layout)cmpCustomExpressionlayout);
        this.customExpression = new WTextExpression(this.cmpCustomExpression, 0, Messages.ImageSelectionDialog_EnterExpression, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                FileSelectionDialog.this.jrFileExpression = exp;
            }
        };
        this.customExpression.setLayoutData(new GridData(4, 4, true, true));
    }

    private void createURLOptionsContainer() {
        this.cmpURL = new Composite((Composite)this.grpOptions, 0);
        this.cmpURL.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel = new Label(this.cmpURL, 0);
        lblNewLabel.setText(Messages.ImageSelectionDialog_EnterURL);
        this.txtURL = new Text(this.cmpURL, 2048);
        this.txtURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSelectionDialog.this.handleTxtUrlChange();
            }
        });
    }

    public void handleTxtUrlChange() {
        String imageURLText;
        this.fileExpressionText = imageURLText = this.txtURL.getText();
    }

    protected void showCustomExpression(String expression) {
        this.changeFileSelectionMode((Control)this.cmpCustomExpression);
        this.btnWorkspaceResource.setSelection(false);
        this.btnAbsolutePath.setSelection(false);
        this.btnNoFile.setSelection(false);
        this.btnUrlRemote.setSelection(false);
        this.btnCustomExpression.setSelection(true);
        this.customExpression.setExpression(new JRDesignExpression(expression));
    }

    public void changeFileSelectionMode(Control newTopControl) {
        this.fileExpressionText = null;
        this.txtResourcePath.setText("");
        this.txtFilesystemPath.setText("");
        this.txtURL.setText("");
        this.customExpression.setExpression(null);
        this.grpOptionsLayout.topControl = newTopControl;
        this.grpOptions.layout();
        for (IFileSelection fs : this.fselectors) {
            fs.changeSelectionMode(newTopControl);
        }
    }

    protected IFile selectFileFromWorkspace() {
        boolean isok;
        IFile file = null;
        FilteredResourcesSelectionDialog fd = new FilteredResourcesSelectionDialog(UIUtils.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        fd.setInitialPattern(this.getDefaultResourcesPattern());
        boolean bl = isok = fd.open() == 0;
        if (isok) {
            file = (IFile)fd.getFirstResult();
            String filepath = this.getRootRelativePath(file.getLocation().toOSString());
            this.txtResourcePath.setText(filepath);
            this.fileExpressionText = StringUtils.replaceBackslashWithDoubleBackslash((String)filepath);
        } else {
            this.txtResourcePath.setText("");
        }
        return file;
    }

    private String getRootRelativePath(String file) {
        if (!Misc.isNullOrEmpty((String)file)) {
            Path cpath = Paths.get(file, new String[0]);
            IFile f = (IFile)this.jConfig.get("ifile");
            Path fpath = Paths.get(f.getLocation().toOSString(), new String[0]);
            if (fpath.getParent().equals(cpath.getParent())) {
                return cpath.getFileName().toString();
            }
            for (String p : this.jConfig.getEditorContext().getRepositoryRoots()) {
                Path rpath = Paths.get(p, new String[0]);
                if (!cpath.startsWith(rpath)) continue;
                String path = rpath.relativize(cpath).toString();
                if (!(path = FilenameUtils.separatorsToUnix((String)path)).startsWith("/")) {
                    path = "/" + path;
                }
                return path;
            }
        }
        return file;
    }

    protected String getDefaultResourcesPattern() {
        return ALL_FILES_TYPE;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{ALL_FILES_TYPE};
    }

    @Override
    public String getSupportedTypeName(String type) {
        return ALL_FILES_TYPE.equals(type) ? Messages.FileSelectionDialog_AllFilesText : type;
    }

    private String[] getFileExtensionsNames() {
        String[] types = this.getSupportedTypes();
        String[] result = new String[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = this.getSupportedTypeName(types[i]);
            ++i;
        }
        return result;
    }

    private void selectFileFromFilesystem() {
        String selection;
        Shell tmpShell = new Shell(UIUtils.getDisplay());
        FileDialog fd = new FileDialog(tmpShell);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        fd.setFilterPath(root.getLocation().toOSString());
        String[] extensions = this.getSupportedTypes();
        String[] extensionNames = this.getFileExtensionsNames();
        fd.setFilterExtensions(extensions);
        if (extensions.length == extensionNames.length) {
            fd.setFilterNames(extensionNames);
        }
        if ((selection = fd.open()) != null) {
            this.txtFilesystemPath.setText(selection);
            this.handleTxtFilesystemPathChange();
        }
        tmpShell.dispose();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void configureDialog(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
    }

    public int open() {
        if (this.jConfig == null) {
            throw new RuntimeException(Messages.ImageSelectionDialog_Error);
        }
        return super.open();
    }

    protected void okPressed() {
        if (!this.btnCustomExpression.getSelection()) {
            if (this.fileExpressionText != null) {
                this.jrFileExpression = new JRDesignExpression();
                this.jrFileExpression.setText("\"" + this.fileExpressionText + "\"");
            } else {
                this.jrFileExpression = null;
            }
        }
        super.okPressed();
    }

    public void setFileExpressionText(String imageExpressionText) {
        this.fileExpressionText = imageExpressionText;
    }

    public JRDesignExpression getFileExpression() {
        return this.jrFileExpression;
    }

    protected boolean allowNoFileOption() {
        return true;
    }
}

