/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.properties.IEditablePropertySource;
import com.jaspersoft.studio.properties.view.validation.IValidable;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;

public abstract class ANode
implements INode,
Serializable,
IAdaptable,
Cloneable,
IValidable,
IEditablePropertySource {
    public static final long serialVersionUID = 10200L;
    private ANode parent;
    private List<INode> children;
    private Object value;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean visible = true;
    private List<ValidationError> validationErrors = null;
    private boolean redoValidation = true;
    private boolean editable = true;
    private static IIconDescriptor iconDescriptor;
    private transient INode root;
    private Set<ANode> dependents;
    private transient JasperReportsConfiguration jConfig;
    private boolean cut = false;

    public ANode() {
    }

    @Override
    public String getToolTip() {
        return this.getDisplayText();
    }

    @Override
    public StyledString getStyledDisplayText() {
        return new StyledString(this.getDisplayText());
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    public ANode(ANode parent, int newIndex) {
        if (parent != null) {
            this.setParent(parent, newIndex);
        }
    }

    public ANode(ANode parent, Object value, int newIndex) {
        if (parent != null) {
            this.setParent(parent, newIndex);
        }
        this.setValue(value);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("report");
        }
        return iconDescriptor;
    }

    @Override
    public INode getRoot() {
        if (this.root == null && this.getParent() != null) {
            this.root = this.getParent().getRoot();
        }
        return this.root;
    }

    public void register() {
        this.root = null;
        INode troot = this.getRoot();
        if (troot != null && troot instanceof ANode) {
            ((ANode)troot).register(this);
        }
    }

    public void unregister() {
        if (this.root != null && this.root instanceof ANode) {
            ((ANode)this.root).unregister(this);
        }
        this.root = null;
    }

    public void register(Object key, ANode value) {
    }

    public void unregister(Object key) {
    }

    public void register(ANode n) {
        this.register(n.getValue(), n);
    }

    public void unregister(ANode n) {
        this.unregister(n.getValue());
    }

    public void setParent(ANode newparent, int newIndex) {
        if (this.parent != null) {
            this.unregister();
            this.getPropertyChangeSupport().removePropertyChangeListener(this.parent);
            if (this.parent.getChildren() != null) {
                this.parent.getChildren().remove(this);
            }
            this.parent = null;
            this.unsetDependents();
        }
        if (newparent != null) {
            this.visible = newparent.visible;
            this.register();
            this.parent = newparent;
            if (newIndex >= 0 && newIndex < newparent.getChildren().size()) {
                newparent.getChildren().add(newIndex, this);
            } else {
                newparent.getChildren().add(this);
            }
            this.getPropertyChangeSupport().addPropertyChangeListener(newparent);
        }
    }

    public void setChildListener(ANode child) {
        this.unsetChildListener(child);
        if (child != null) {
            child.getPropertyChangeSupport().addPropertyChangeListener(this);
        }
        if (this.dependents == null) {
            this.dependents = new HashSet<ANode>();
        }
        this.dependents.add(child);
    }

    public void unsetChildListener(ANode child) {
        if (child != null) {
            child.getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        if (this.dependents != null) {
            this.dependents.remove(child);
        }
    }

    public void unsetDependents() {
        if (this.dependents != null) {
            for (ANode n : this.dependents) {
                n.getPropertyChangeSupport().removePropertyChangeListener(this);
            }
            this.dependents.clear();
        }
    }

    public void addChild(ANode child) {
        child.setParent(this, -1);
    }

    public void addChild(ANode child, int index) {
        child.setParent(this, index);
    }

    public boolean hasParent(ANode node) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.equals(node) || this.parent.hasParent(node);
    }

    public ANode[] flatten() {
        ArrayList<ANode> result = new ArrayList<ANode>();
        this.doFlatten(this, result);
        return result.toArray(new ANode[result.size()]);
    }

    private void doFlatten(ANode node, ArrayList<ANode> all) {
        all.add(node);
        List<INode> tchildren = node.getChildren();
        for (INode n : tchildren) {
            this.doFlatten((ANode)n, all);
        }
    }

    public void removeChild(ANode child) {
        child.setJasperConfiguration(this.getJasperConfiguration());
        child.setParent(null, -1);
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void removeChildren() {
        if (this.children != null) {
            this.removeChildren(this.children);
        }
    }

    public void removeChildren(List<? extends INode> children) {
        Object[] array = children.toArray();
        int i = 0;
        while (i < array.length) {
            this.removeChild((ANode)array[i]);
            ++i;
        }
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.revalidateChildren();
        if (evt.getPropertyName().equals("children") && evt.getSource() == this.getValue()) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                int newIndex = -1;
                if (evt instanceof CollectionElementAddedEvent) {
                    newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                }
                ANode n = ReportFactory.createNode(this, evt.getNewValue(), newIndex);
                if (evt.getNewValue() instanceof JRElementGroup) {
                    JRElementGroup jrFrame = (JRElementGroup)evt.getNewValue();
                    ReportFactory.createElementsForBand(n, jrFrame.getChildren());
                }
            } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    this.removeChild((ANode)n);
                    break;
                }
            } else {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    n.setValue(evt.getNewValue());
                }
            }
        }
        this.firePropertyChange(evt);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.getPropertyChangeSupport().firePropertyChange(evt);
    }

    @Override
    public List<INode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<INode>();
        }
        return this.children;
    }

    @Override
    public ANode getParent() {
        return this.parent;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (this.value == value) {
            return;
        }
        this.unregister();
        if (this.value instanceof JRChangeEventsSupport) {
            ((JRChangeEventsSupport)this.value).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (value != null) {
            this.value = value;
            if (this.value instanceof JRChangeEventsSupport) {
                ((JRChangeEventsSupport)this.value).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.register();
            return;
        }
        this.value = value;
    }

    public EditPart getFigureEditPart() {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener o = propertyChangeListenerArray[n2];
            if (o instanceof FigureEditPart || o instanceof CalloutEditPart || o instanceof PinEditPart) {
                return (EditPart)o;
            }
            ++n2;
        }
        return null;
    }

    public EditPart getTreeEditPart() {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener o = propertyChangeListenerArray[n2];
            if (o instanceof TreeEditPart) {
                return (EditPart)o;
            }
            ++n2;
        }
        return null;
    }

    public JRSimpleTemplate getStylesTemplate() {
        for (INode node : this.getRoot().getChildren()) {
            if (!(node instanceof MStylesTemplate)) continue;
            return (JRSimpleTemplate)node.getValue();
        }
        return null;
    }

    @Override
    public JasperDesign getJasperDesign() {
        INode r = this.getRoot();
        if (r != null && r.getValue() instanceof JasperDesign) {
            return (JasperDesign)r.getValue();
        }
        if (this.getJasperConfiguration() != null) {
            return this.getJasperConfiguration().getJasperDesign();
        }
        return null;
    }

    public void setJasperConfiguration(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
    }

    public JasperReportsConfiguration getJasperConfiguration() {
        if (this.jConfig != null) {
            return this.jConfig;
        }
        if (this.parent != null) {
            return this.parent.getJasperConfiguration();
        }
        return null;
    }

    public int findParent(ANode n) {
        int depth = 0;
        ANode node = this;
        while (node != null) {
            if (node == n) {
                return depth;
            }
            node = node.getParent();
            ++depth;
        }
        return -1;
    }

    public int findElement(Object obj) {
        if (obj == null) {
            return -1;
        }
        List<INode> children2 = this.getChildren();
        int i = 0;
        while (i < children2.size()) {
            if (children2.get(i).getValue() == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isCut() {
        return this.cut;
    }

    public void setCut(boolean cut) {
        this.cut = cut;
    }

    final void intReset() {
        this.children = null;
        this.parent = null;
    }

    public ANode clone() {
        try {
            ANode clone = (ANode)super.clone();
            if (this.children != null) {
                clone.intReset();
                ArrayList<INode> oldChildren = new ArrayList<INode>(this.children);
                ArrayList<ANode> ch = new ArrayList<ANode>();
                for (INode iNode : this.children) {
                    ch.add(((ANode)iNode).clone());
                }
                for (ANode aNode : ch) {
                    clone.addChild(aNode);
                }
                for (INode iNode : oldChildren) {
                    this.addChild((ANode)iNode);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ANode.class || adapter == INode.class) {
            return this;
        }
        return null;
    }

    public boolean isFirst() {
        if (this.parent != null && this.parent.getChildren() != null && !this.parent.getChildren().isEmpty()) {
            return this.parent.getChildren().indexOf(this) == 0;
        }
        return true;
    }

    public boolean canAcceptChildren(ANode child) {
        return true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean showChildren() {
        return true;
    }

    public void createSubeditor() {
    }

    protected List<ValidationError> doValidation() {
        return null;
    }

    public void revalidateChildren() {
        this.redoValidation = true;
        for (INode node : this.getChildren()) {
            ((ANode)node).revalidateChildren();
        }
    }

    public List<ValidationError> validate() {
        if (this.redoValidation) {
            this.validationErrors = this.doValidation();
            this.redoValidation = false;
        }
        return this.validationErrors;
    }

    public Point getAvailableSize() {
        JasperDesign jd = this.getJasperDesign();
        int w = jd.getPageWidth() + 20;
        int h = jd.getPageHeight() + 20;
        if ((w *= 4) < 1000) {
            w = 1000;
        }
        if ((h *= 4) < 1000) {
            h = 1000;
        }
        return new Point(w, h);
    }

    protected void addElementStyle(JRStyle style, Map<String, List<ANode>> map) {
        if (style == null) {
            return;
        }
        List<ANode> list = map.get(style.getName());
        if (list == null) {
            list = new ArrayList<ANode>();
            list.add(this);
            map.put(style.getName(), list);
        } else if (!list.contains(this)) {
            list.add(this);
        }
    }

    protected void mergeElementStyle(Map<String, List<ANode>> destination, Map<String, List<ANode>> origin) {
        for (Map.Entry<String, List<ANode>> entry : origin.entrySet()) {
            String style = entry.getKey();
            List<ANode> elements = entry.getValue();
            List<ANode> targetElements = destination.get(style);
            if (targetElements == null) {
                destination.put(style, elements);
                continue;
            }
            targetElements.addAll(elements);
        }
    }

    public Map<String, List<ANode>> getUsedStyles() {
        return new HashMap<String, List<ANode>>();
    }

    public void setStyle(JRStyle style) {
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

