/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.CopyElementExpressionProperty;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;

public class CopyElementProperty
extends CopyElementExpressionProperty {
    public CopyElementProperty(String propertyName, Object value) {
        super(propertyName, value);
    }

    @Override
    protected Command getPasteCommand(APropertyNode target) {
        return new PastePropertyCommand(target);
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    private class PastePropertyCommand
    extends Command {
        private boolean alreadyPresent = false;
        private String oldValue;
        private APropertyNode target;

        public PastePropertyCommand(APropertyNode target) {
            this.target = target;
        }

        public boolean canExecute() {
            return CopyElementProperty.this.propertyName != null && this.target != null;
        }

        public void execute() {
            JRPropertiesMap elementProperties = (JRPropertiesMap)this.target.getPropertyValue("PROPERTY_MAP");
            if (elementProperties == null) {
                elementProperties = new JRPropertiesMap();
            }
            if (elementProperties.containsProperty(CopyElementProperty.this.propertyName)) {
                this.alreadyPresent = true;
                this.oldValue = elementProperties.getProperty(CopyElementProperty.this.propertyName);
            }
            elementProperties.setProperty(CopyElementProperty.this.propertyName, CopyElementProperty.this.value);
            this.target.setPropertyValue("PROPERTY_MAP", elementProperties);
        }

        public void undo() {
            JRPropertiesMap elementProperties = (JRPropertiesMap)this.target.getPropertyValue("PROPERTY_MAP");
            if (elementProperties == null) {
                elementProperties = new JRPropertiesMap();
            }
            if (this.alreadyPresent) {
                elementProperties.setProperty(CopyElementProperty.this.propertyName, this.oldValue);
            } else {
                elementProperties.removeProperty(CopyElementProperty.this.propertyName);
            }
            this.target.setPropertyValue("PROPERTY_MAP", elementProperties);
        }
    }
}

