/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.ILineBox;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.property.descriptor.box.BoxPropertyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class MGraphicElementLineBox
extends MGraphicElement
implements IGraphicElement,
ILineBox {
    public static final long serialVersionUID = 10200L;
    public static final String LINE_BOX = "LineBox";
    private MLineBox lineBox;

    public MGraphicElementLineBox() {
    }

    public MGraphicElementLineBox(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MGraphicElementLineBox(ANode parent, JRDesignElement jrLine, int newIndex) {
        super(parent, jrLine, newIndex);
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = super.getStylesDescriptors();
        if (this.getValue() == null) {
            return result;
        }
        MLineBox element = (MLineBox)this.getPropertyValue(LINE_BOX);
        result.put(LINE_BOX, element);
        return result;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        BoxPropertyDescriptor lineBoxD = new BoxPropertyDescriptor(LINE_BOX, Messages.common_line_box);
        lineBoxD.setDescription(Messages.MGraphicElementLineBox_line_box_description);
        desc.add((IPropertyDescriptor)lineBoxD);
        lineBoxD.setCategory(Messages.common_graphic);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#box");
    }

    public MLineBox getLineBox() {
        if (this.lineBox == null) {
            JRBoxContainer jrGraphicElement = (JRBoxContainer)this.getValue();
            this.lineBox = new MLineBox(jrGraphicElement.getLineBox(), this);
            this.lineBox.setJasperConfiguration(this.getJasperConfiguration());
            this.setChildListener(this.lineBox);
        }
        return this.lineBox;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(LINE_BOX)) {
            return this.getLineBox();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public JRBoxContainer getBoxContainer() {
        return (JRBoxContainer)this.getValue();
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("bottomPadding");
        result.add("leftPadding");
        result.add("padding");
        result.add("rightPadding");
        result.add("topPadding");
        result.add("lineColor");
        result.add("lineStyle");
        result.add("lineWidth");
        return result;
    }

    private void transferLinePenProeprties(JRPen jrTarget, JRPen source) {
        if (jrTarget != null && source != null) {
            jrTarget.setLineColor(this.getColorClone(source.getOwnLineColor()));
            jrTarget.setLineStyle(source.getOwnLineStyleValue());
            Float lineWidth = source.getOwnLineWidth();
            jrTarget.setLineWidth(lineWidth != null ? Float.valueOf(lineWidth.floatValue()) : null);
        }
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRLineBox jrSourceBox = this.getBoxContainer().getLineBox();
        if (jrSourceBox != null && target instanceof JRBoxContainer) {
            JRLineBox jrTargetBox = ((JRBoxContainer)target).getLineBox();
            jrTargetBox.setPadding(jrSourceBox.getOwnPadding());
            jrTargetBox.setTopPadding(jrSourceBox.getOwnTopPadding());
            jrTargetBox.setBottomPadding(jrSourceBox.getOwnBottomPadding());
            jrTargetBox.setLeftPadding(jrSourceBox.getOwnLeftPadding());
            jrTargetBox.setRightPadding(jrSourceBox.getOwnRightPadding());
            this.transferLinePenProeprties((JRPen)jrTargetBox.getPen(), (JRPen)jrSourceBox.getPen());
            this.transferLinePenProeprties((JRPen)jrTargetBox.getLeftPen(), (JRPen)jrSourceBox.getLeftPen());
            this.transferLinePenProeprties((JRPen)jrTargetBox.getRightPen(), (JRPen)jrSourceBox.getRightPen());
            this.transferLinePenProeprties((JRPen)jrTargetBox.getTopPen(), (JRPen)jrSourceBox.getTopPen());
            this.transferLinePenProeprties((JRPen)jrTargetBox.getBottomPen(), (JRPen)jrSourceBox.getBottomPen());
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        MLineBox lineBox = (MLineBox)this.getPropertyValue(LINE_BOX);
        lineBox.setEditable(editable);
    }

    protected void applyDefaultValue() {
        DefaultManager.INSTANCE.hasDefault();
    }

    @Override
    public boolean forcePropertyChildrenReset(Object id) {
        if (id.equals(LINE_BOX)) {
            return true;
        }
        return super.forcePropertyChildrenReset(id);
    }
}

