/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.property.IPostSetValue;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRStyle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class PostSetPadding
implements IPostSetValue {
    @Override
    public Command postSetValue(IPropertySource target, Object prop, Object newValue, Object oldValue) {
        if (target instanceof MLineBox && this.isPaddingOperation(prop)) {
            ANode container = ((MLineBox)target).getContainer();
            if (container instanceof MStyle) {
                List<ANode> nodesUsingStyle;
                JRStyle style = ((MStyle)container).getValue();
                MReport root = ModelUtils.getReport(container);
                if (root != null && (nodesUsingStyle = root.getUsedStyles().get(style.getName())) != null) {
                    JSSCompoundCommand cmd = new JSSCompoundCommand(root);
                    for (ANode node : nodesUsingStyle) {
                        LayoutCommand layoutCmd = LayoutManager.createRelayoutCommand(node);
                        if (layoutCmd == null) continue;
                        cmd.add(layoutCmd);
                    }
                    if (!cmd.isEmpty()) {
                        return cmd;
                    }
                }
            } else {
                return LayoutManager.createRelayoutCommand(container);
            }
        }
        return null;
    }

    protected boolean isPaddingOperation(Object prop) {
        return prop.equals("leftPadding") || prop.equals("bottomPadding") || prop.equals("rightPadding") || prop.equals("topPadding") || prop.equals("padding");
    }
}

