/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band;

import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.IPastableGraphic;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.JRBandDTO;
import com.jaspersoft.studio.model.band.rv.RVPropertyDescriptor;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRPrintWhenExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.properties.JPropertiesPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSPixelNotNullValidator;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MBand
extends APropertyNode
implements IGraphicElement,
IPastable,
IPastableGraphic,
IContainer,
IContainerLayout,
IContainerEditPart,
IGroupElement {
    public static final long serialVersionUID = 10200L;
    private static final Integer CONST_HEIGHT = new Integer(50);
    private static IPropertyDescriptor[] descriptors;
    private static IIconDescriptor iconDescriptor;
    protected int bandIndex = -1;
    private BandTypeEnum bandType;
    private JRBandDTO returnValuesDTO;
    private static int BAND_GAP;
    private static NamedEnumPropertyDescriptor<SplitTypeEnum> splitStyleD;

    static {
        BAND_GAP = 0;
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("band");
        }
        return iconDescriptor;
    }

    public MBand() {
    }

    public MBand(ANode parent, JRBand jrband, BandTypeEnum bandtype, int newIndex) {
        super(parent, newIndex);
        this.bandType = bandtype;
        this.setValue(jrband);
    }

    public int getDetailIndex() {
        return this.bandIndex;
    }

    public void setBandIndex(int detailIndex) {
        this.bandIndex = detailIndex;
        INode n = this.getRoot();
        if (n instanceof MReport && this.getValue() != null) {
            MReport mrep = (MReport)n;
            mrep.setBandIndex(this.bandIndex, this.getValue());
        }
    }

    @Override
    public void setValue(Object value) {
        JRDesignBand oldValue = this.getValue();
        super.setValue(value);
        this.refreshIndex(oldValue, this.getValue());
    }

    protected void refreshIndex(JRDesignBand oldValue, JRDesignBand newValue) {
        INode n = this.getRoot();
        if (n instanceof MReport) {
            MReport mrep = (MReport)n;
            mrep.removeBandIndex(oldValue);
            if (this.getValue() != null) {
                Integer index = mrep.getBandIndex(this.getValue());
                if (index != null) {
                    this.bandIndex = index;
                } else {
                    this.setBandIndex(this.getFreeIndex());
                }
            }
        }
    }

    protected int getFreeIndex() {
        int actualIndex = 1;
        if (this.getParent() instanceof MReport) {
            MReport report = (MReport)this.getParent();
            HashSet<Integer> reservedIndexes = new HashSet<Integer>();
            for (INode node : report.getChildren()) {
                MBand band;
                if (node == this || !(node instanceof MBand) || !this.isSameBandType(band = (MBand)node)) continue;
                reservedIndexes.add(band.getDetailIndex());
            }
            while (reservedIndexes.contains(actualIndex)) {
                ++actualIndex;
            }
        }
        return actualIndex;
    }

    public boolean isSameBandType(MBand band) {
        return this.bandType == band.getBandType();
    }

    public BandTypeEnum getBandType() {
        return this.bandType;
    }

    public JRDesignBand getValue() {
        return (JRDesignBand)super.getValue();
    }

    @Override
    public String getDisplayText() {
        JRDesignBand value = this.getValue();
        String hiddenText = new String();
        if (!this.isVisible()) {
            hiddenText = Messages.MBand_hiddenLabel;
        }
        if (this.bandType.equals((Object)BandTypeEnum.DETAIL)) {
            String index = "";
            if (this.bandIndex != -1) {
                index = " " + String.valueOf(this.bandIndex);
            }
            if (value != null) {
                return String.valueOf(Messages.MBand_detail) + index + " [" + value.getHeight() + "px]" + hiddenText;
            }
            return String.valueOf(Messages.MBand_detail) + index + " ";
        }
        if (value == null) {
            return MessagesByKeys.getString(this.bandType.getName());
        }
        return String.valueOf(MessagesByKeys.getString(this.bandType.getName())) + " " + hiddenText;
    }

    public String getSimpleDisplayName() {
        JRDesignBand value = this.getValue();
        if (this.bandType.equals((Object)BandTypeEnum.DETAIL) || value == null) {
            String index = "";
            if (this.bandIndex != -1) {
                index = " " + String.valueOf(this.bandIndex);
            }
            return String.valueOf(MessagesByKeys.getString(this.bandType.getName())) + index;
        }
        return MessagesByKeys.getString(value.getOrigin().getBandTypeValue().getName());
    }

    @Override
    public Color getForeground() {
        if (this.getValue() == null) {
            return UIUtils.getSystemColor((int)39);
        }
        return UIUtils.getSystemColor((int)21);
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MBand.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        if (this.getValue() != null) {
            return String.valueOf(Messages.common_band) + ": " + this.getDisplayText() + " \t";
        }
        return MBand.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = this.getDescriptors();
        if (descriptors == null) {
            ArrayList<IPropertyDescriptor> desc = new ArrayList<IPropertyDescriptor>();
            this.createPropertyDescriptors(desc);
            descriptors = desc.toArray(new IPropertyDescriptor[desc.size()]);
            this.setDescriptors(descriptors);
        }
        this.postDescriptors(descriptors);
        return descriptors;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        PixelPropertyDescriptor heightD = new PixelPropertyDescriptor("height", Messages.common_height);
        heightD.setValidator(new JSSPixelNotNullValidator());
        heightD.setDescription(Messages.MBand_height_description);
        desc.add((IPropertyDescriptor)heightD);
        splitStyleD = new NamedEnumPropertyDescriptor<SplitTypeEnum>("splitType", Messages.common_split_type, SplitTypeEnum.IMMEDIATE, NullEnum.NULL);
        splitStyleD.setDescription(Messages.MBand_split_type_dscription);
        desc.add((IPropertyDescriptor)splitStyleD);
        splitStyleD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#band_splitType"));
        JRPrintWhenExpressionPropertyDescriptor printWhenExpD = new JRPrintWhenExpressionPropertyDescriptor("printWhenExpression", Messages.common_print_when_expression);
        printWhenExpD.setDescription(Messages.MBand_print_when_expression_description);
        desc.add((IPropertyDescriptor)printWhenExpD);
        printWhenExpD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#printWhenExpression"));
        JPropertiesPropertyDescriptor propertiesMapD = new JPropertiesPropertyDescriptor("PROPERTY_MAP", Messages.common_properties, this.getJasperConfiguration(), this.getValue());
        propertiesMapD.setDescription(Messages.common_properties);
        desc.add((IPropertyDescriptor)propertiesMapD);
        RVPropertyDescriptor returnValuesD = new RVPropertyDescriptor("returnValues", Messages.common_return_values);
        returnValuesD.setDescription(Messages.MSubreport_return_values_description);
        desc.add((IPropertyDescriptor)returnValuesD);
        returnValuesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#returnValue"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#band");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("height", new DefaultValue(CONST_HEIGHT, false));
        int splitTypeDef = NamedEnumPropertyDescriptor.getIntValue(SplitTypeEnum.PREVENT, NullEnum.NULL, null);
        defaultsMap.put("splitType", new DefaultValue(splitTypeDef, true));
        defaultsMap.put("printWhenExpression", new DefaultValue(null, true));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignBand jrband = this.getValue();
        if (jrband != null) {
            if (id.equals("height")) {
                return new Integer(jrband.getHeight());
            }
            if (id.equals("splitType")) {
                return splitStyleD.getIntValue(jrband.getSplitTypeValue());
            }
            if (id.equals("printWhenExpression")) {
                return ExprUtil.getExpression(jrband.getPrintWhenExpression());
            }
            if (id.equals("PROPERTY_MAP")) {
                return jrband.getPropertiesMap().cloneProperties();
            }
            if (id.equals("returnValues")) {
                if (this.returnValuesDTO == null) {
                    this.returnValuesDTO = new JRBandDTO();
                    this.returnValuesDTO.setjConfig(this.getJasperConfiguration());
                    this.returnValuesDTO.setBand(jrband);
                }
                this.returnValuesDTO.setValue(JRCloneUtils.cloneList((List)jrband.getReturnValuesList()));
                return this.returnValuesDTO;
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignBand jrband = this.getValue();
        if (jrband != null) {
            if (id.equals("height")) {
                jrband.setHeight(Math.max(0, (Integer)Misc.nvl((Object)value, (Object)0)));
            } else if (id.equals("splitType")) {
                jrband.setSplitType(splitStyleD.getEnumValue(value));
            } else if (id.equals("printWhenExpression")) {
                jrband.setPrintWhenExpression(ExprUtil.setValues(jrband.getPrintWhenExpression(), value, null));
            } else if (id.equals("PROPERTY_MAP")) {
                JRPropertiesMap v = (JRPropertiesMap)value;
                String[] names = jrband.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    jrband.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                names = v.getPropertyNames();
                i = 0;
                while (i < names.length) {
                    jrband.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                    ++i;
                }
                this.getPropertyChangeSupport().firePropertyChange("PROPERTY_MAP", false, true);
            } else if (id.equals("returnValues")) {
                this.returnValuesDTO = (JRBandDTO)value;
                List<ExpressionReturnValue> list = this.returnValuesDTO.getValue();
                for (ExpressionReturnValue srv : jrband.getReturnValues()) {
                    jrband.removeReturnValue(srv);
                }
                for (ExpressionReturnValue j : list) {
                    jrband.addReturnValue(j);
                }
            }
        }
    }

    @Override
    public int getDefaultHeight() {
        return 50;
    }

    @Override
    public int getDefaultWidth() {
        return 800;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    public static JRDesignBand createJRBand() {
        JRDesignBand jrBand = new JRDesignBand();
        jrBand.setHeight(50);
        return jrBand;
    }

    @Override
    public Rectangle getBounds() {
        ANode parent = this.getParent();
        Rectangle parentBounds = ((IGraphicElement)((Object)parent)).getBounds();
        Rectangle bounds = new Rectangle(parentBounds);
        if (this.getValue() == null) {
            return parentBounds;
        }
        bounds.setSize(parentBounds.width, this.getValue().getHeight());
        int h = 0;
        for (INode b : parent.getChildren()) {
            if (b == this) break;
            if (!(b instanceof MBand) || b.getValue() == null) continue;
            h += ((JRDesignBand)b.getValue()).getHeight() + BAND_GAP;
        }
        bounds.setLocation(parentBounds.x, h + this.getJasperDesign().getTopMargin());
        return bounds;
    }

    @Override
    public JRPropertiesHolder[] getPropertyHolder() {
        return new JRPropertiesHolder[]{this.getValue()};
    }

    @Override
    public JRElementGroup getJRElementGroup() {
        return this.getValue();
    }

    public static boolean isMultiBand(MBand mband) {
        return mband.getBandType() == BandTypeEnum.DETAIL || mband.getBandType() == BandTypeEnum.GROUP_HEADER || mband.getBandType() == BandTypeEnum.GROUP_FOOTER;
    }

    @Override
    public boolean canAcceptChildren(ANode child) {
        return this.getValue() != null;
    }

    @Override
    public Map<String, List<ANode>> getUsedStyles() {
        Map<String, List<ANode>> map = super.getUsedStyles();
        for (INode node : this.getChildren()) {
            if (!(node instanceof ANode)) continue;
            this.mergeElementStyle(map, ((ANode)node).getUsedStyles());
        }
        return map;
    }

    @Override
    public ILayout getDefaultLayout() {
        return LayoutManager.getLayout(FreeLayout.class.getName());
    }
}

