/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroup;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.gef.commands.Command;

public class ReorderBandCommandByRelativeIndex
extends Command {
    private boolean bandMoved = false;
    private int delta;
    private JRDesignBand jrBand;
    private JRDesignSection jrDesignSection;

    public ReorderBandCommandByRelativeIndex(MBandGroup child, int delta) {
        super(Messages.common_reorder_elements);
        this.delta = delta;
        this.jrDesignSection = (JRDesignSection)child.getSection();
        this.jrBand = child.getValue();
    }

    public ReorderBandCommandByRelativeIndex(MBand child, MReport parent, int delta) {
        super(Messages.common_reorder_elements);
        this.delta = delta;
        this.jrDesignSection = (JRDesignSection)parent.getJasperDesign().getDetailSection();
        this.jrBand = child.getValue();
    }

    public void execute() {
        List bList = this.jrDesignSection.getBandsList();
        int currentPosition = bList.indexOf(this.jrBand);
        int newPosition = currentPosition + this.delta;
        if (newPosition >= 0 && newPosition < bList.size() && newPosition != currentPosition) {
            bList.remove(this.jrBand);
            this.bandMoved = true;
            bList.add(newPosition, this.jrBand);
            this.jrDesignSection.getEventSupport().fireIndexedPropertyChange("changeBandPosition", newPosition, currentPosition, -1);
        }
    }

    public void undo() {
        if (!this.bandMoved) {
            return;
        }
        List bList = this.jrDesignSection.getBandsList();
        int currentPosition = bList.indexOf(this.jrBand);
        int newPosition = currentPosition - this.delta;
        if (newPosition >= 0 && newPosition < bList.size() && newPosition != currentPosition) {
            bList.remove(this.jrBand);
            bList.add(newPosition, this.jrBand);
            this.jrDesignSection.getEventSupport().fireIndexedPropertyChange("changeBandPosition", newPosition, currentPosition, -1);
        }
    }
}

