/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroup;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import java.beans.PropertyChangeEvent;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class ReorderBandCommandBySibling
extends Command {
    private JRBand oldUpperBand;
    private JRBand newUpperBand;
    private JRDesignBand jrBand;
    private JRDesignSection jrDesignSection;

    public ReorderBandCommandBySibling(MBandGroup child, JRBand newUpperBand) {
        super(Messages.common_reorder_elements);
        this.newUpperBand = newUpperBand;
        this.jrDesignSection = (JRDesignSection)child.getSection();
        this.jrBand = child.getValue();
    }

    public ReorderBandCommandBySibling(MBand child, MReport parent, JRBand newUpperBand) {
        super(Messages.common_reorder_elements);
        this.newUpperBand = newUpperBand;
        this.jrDesignSection = (JRDesignSection)parent.getJasperDesign().getDetailSection();
        this.jrBand = child.getValue();
    }

    public void execute() {
        this.doExecute();
    }

    private void doExecute() {
        int newInd = 0;
        List bList = this.jrDesignSection.getBandsList();
        int oldInd = bList.indexOf(this.jrBand);
        this.oldUpperBand = oldInd == 0 ? null : (JRBand)bList.get(oldInd - 1);
        bList.remove(this.jrBand);
        if (this.newUpperBand != null) {
            newInd = bList.indexOf(this.newUpperBand) + 1;
        }
        if (newInd >= 0 && newInd < bList.size()) {
            bList.add(newInd, this.jrBand);
        } else {
            bList.add(this.jrBand);
            newInd = bList.size() - 1;
        }
        this.jrDesignSection.getEventSupport().fireIndexedPropertyChange("changeBandPosition", newInd, oldInd, -1);
    }

    public void undo() {
        List bList = this.jrDesignSection.getBandsList();
        int oldInd = bList.indexOf(this.jrBand);
        int newInd = 0;
        bList.remove(this.jrBand);
        if (this.oldUpperBand != null) {
            newInd = bList.indexOf(this.oldUpperBand) + 1;
        }
        if (newInd >= 0 && newInd < bList.size()) {
            bList.add(newInd, this.jrBand);
        } else {
            bList.add(this.jrBand);
            newInd = bList.size() - 1;
        }
        this.jrDesignSection.getEventSupport().fireIndexedPropertyChange("changeBandPosition", newInd, oldInd, -1);
    }

    public static JSSCompoundCommand moveBandsCommand(List<MBand> moved, JRBand upperlocation, final EditPart parentPart) {
        JSSCompoundCommand cmd;
        block4: {
            MBand firstBand;
            block5: {
                block3: {
                    final ANode report = moved.get(0).getParent();
                    cmd = new JSSCompoundCommand(report){

                        @Override
                        protected void refreshVisuals() {
                            PropertyChangeEvent event = new PropertyChangeEvent(report.getJasperDesign(), "refresh", null, null);
                            report.propertyChange(event);
                            for (Object part : parentPart.getChildren()) {
                                ((EditPart)part).refresh();
                            }
                        }

                        private void refreshBandNumbers() {
                        }

                        @Override
                        public void execute() {
                            super.execute();
                            this.refreshBandNumbers();
                            this.refreshVisuals();
                        }

                        @Override
                        public void undo() {
                            super.undo();
                            this.refreshBandNumbers();
                            this.refreshVisuals();
                        }
                    };
                    firstBand = moved.get(0);
                    if (!BandTypeEnum.GROUP_HEADER.equals((Object)firstBand.getBandType())) break block3;
                    for (MBand bandNode : moved) {
                        cmd.add(new ReorderBandCommandBySibling((MBandGroup)bandNode, upperlocation));
                        upperlocation = bandNode.getValue();
                    }
                    break block4;
                }
                if (!BandTypeEnum.GROUP_FOOTER.equals((Object)firstBand.getBandType())) break block5;
                for (MBand bandNode : moved) {
                    cmd.add(new ReorderBandCommandBySibling((MBandGroup)bandNode, upperlocation));
                    upperlocation = bandNode.getValue();
                }
                break block4;
            }
            if (!BandTypeEnum.DETAIL.equals((Object)firstBand.getBandType())) break block4;
            for (MBand bandNode : moved) {
                cmd.add(new ReorderBandCommandBySibling(bandNode, (MReport)bandNode.getParent(), upperlocation));
                upperlocation = bandNode.getValue();
            }
        }
        return cmd;
    }

    public static BandTypeEnum getMoveType(List<?> selectedElements, List<MBand> movedBands) {
        BandTypeEnum lastFound;
        block10: {
            MBandGroup footer;
            JRDesignGroup lastGroup;
            block9: {
                lastFound = null;
                movedBands.clear();
                for (Object node : selectedElements) {
                    if (node instanceof EditPart) {
                        node = ((EditPart)node).getModel();
                    }
                    if (node instanceof MBand) {
                        MBand band = (MBand)node;
                        movedBands.add(band);
                        BandTypeEnum bandType = band.getBandType();
                        if (BandTypeEnum.DETAIL.equals((Object)bandType) || BandTypeEnum.GROUP_FOOTER.equals((Object)bandType) || BandTypeEnum.GROUP_HEADER.equals((Object)bandType)) {
                            if (lastFound == null) {
                                lastFound = bandType;
                                continue;
                            }
                            if (lastFound.equals((Object)bandType)) continue;
                            return null;
                        }
                        return null;
                    }
                    return null;
                }
                if (!BandTypeEnum.GROUP_FOOTER.equals(lastFound)) break block9;
                lastGroup = null;
                for (MBand band : movedBands) {
                    footer = (MBandGroupFooter)band;
                    JRDesignGroup bandGroup = footer.getJrGroup();
                    if (lastGroup == null) {
                        lastGroup = bandGroup;
                        continue;
                    }
                    if (lastGroup == bandGroup) continue;
                    return null;
                }
                break block10;
            }
            if (!BandTypeEnum.GROUP_HEADER.equals(lastFound)) break block10;
            lastGroup = null;
            for (MBand band : movedBands) {
                footer = (MBandGroupHeader)band;
                JRDesignGroup bandGroup = footer.getJrGroup();
                if (lastGroup == null) {
                    lastGroup = bandGroup;
                    continue;
                }
                if (lastGroup == bandGroup) continue;
                return null;
            }
        }
        return lastFound;
    }
}

