/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band.rv;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.band.JRBandDTO;
import com.jaspersoft.studio.model.band.rv.BandReturnValueDialog;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.DesignExpressionReturnValue;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ReturnValuesPropertyPage
extends JSSHelpWizardPage {
    private JRBandDTO dto;
    protected Table table;
    protected TableViewer tableViewer;
    protected String[] toVariables;

    protected ReturnValuesPropertyPage() {
        super("bandreturnvalues");
        this.setTitle(Messages.ReturnValuesPropertyPage_1);
        this.setDescription(Messages.ReturnValuesPropertyPage_2);
    }

    public JRBandDTO getDto() {
        return this.dto;
    }

    public void setDto(JRBandDTO dto) {
        this.dto = dto;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.buildTable(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.minimumWidth = 500;
        gd.widthHint = 500;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.createButtons(bGroup);
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 55, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 55, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, 100, true));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[4];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.common_expression);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.RVPropertyPage_to_variable);
        column[2] = new TableColumn(this.table, 0);
        column[2].setText(Messages.RVPropertyPage_calculation_type);
        column[3] = new TableColumn(this.table, 0);
        column[3].setText(Messages.RVPropertyPage_incrementer_factory_class);
        this.fillTable();
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    protected void fillTable() {
        this.tableViewer.setInput(this.dto.getValue());
        this.isValid();
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setColumnProperties(new String[]{"EXPRESSION", "TOVARIABLE", "CALCULATIONTYPE", "INCREMENTERFACTORYCLASS"});
    }

    private void createButtons(Composite bGroup) {
        NewButton nb = new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                super.afterElementAdded(selement);
                ReturnValuesPropertyPage.this.isValid();
            }
        };
        nb.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                BandReturnValueDialog d = new BandReturnValueDialog(UIUtils.getShell(), ReturnValuesPropertyPage.this.dto.getjConfig(), new DesignExpressionReturnValue(), ReturnValuesPropertyPage.this.getToVariablesNames());
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }
        });
        nb.setEnabled(!this.getAlreadyNonUsedToVariables().isEmpty());
        EditButton<ExpressionReturnValue> editButton = new EditButton<ExpressionReturnValue>(){

            @Override
            protected void afterElementModified(ExpressionReturnValue element, List<ExpressionReturnValue> inlist, int ind) {
                super.afterElementModified(element, inlist, ind);
                ReturnValuesPropertyPage.this.isValid();
            }
        };
        editButton.createEditButtons(bGroup, this.tableViewer, new IEditElement<ExpressionReturnValue>(){

            @Override
            public void editElement(List<ExpressionReturnValue> input, int pos) {
                DesignExpressionReturnValue value = (DesignExpressionReturnValue)input.get(pos);
                BandReturnValueDialog d = new BandReturnValueDialog(UIUtils.getShell(), ReturnValuesPropertyPage.this.dto.getjConfig(), (DesignExpressionReturnValue)value.clone(), ReturnValuesPropertyPage.this.getToVariablesNames());
                if (d.open() == 0) {
                    input.set(pos, (ExpressionReturnValue)d.getValue());
                }
            }
        });
        editButton.editOnDoubleClick();
        new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                ReturnValuesPropertyPage.this.isValid();
            }
        }.createDeleteButton(bGroup, this.tableViewer);
        ListOrderButtons upDownButtons = new ListOrderButtons();
        upDownButtons.createOrderButtons(bGroup, this.tableViewer);
    }

    private void isValid() {
        HashSet<String> names = new HashSet<String>();
        for (ExpressionReturnValue erv : this.dto.getValue()) {
            if (names.contains(erv.getToVariable())) {
                this.setErrorMessage(Messages.ReturnValuesPropertyPage_8);
                this.setPageComplete(false);
                return;
            }
            names.add(erv.getToVariable());
        }
        if (this.dto.getjConfig().getJasperDesign().getMainDataset().getVariables().length == 0) {
            this.setErrorMessage(Messages.ReturnValuesPropertyPage_0);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private HashSet<String> getAlreadyNonUsedToVariables() {
        JRVariable[] vlist;
        HashSet<String> result = new HashSet<String>();
        JRVariable[] jRVariableArray = vlist = this.dto.getjConfig().getJasperDesign().getMainDataset().getVariables();
        int n = vlist.length;
        int n2 = 0;
        while (n2 < n) {
            JRVariable v = jRVariableArray[n2];
            if (!v.isSystemDefined()) {
                boolean exists = false;
                for (ExpressionReturnValue value : this.dto.getValue()) {
                    if (!value.getToVariable().equals(v.getName())) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    result.add(v.getName());
                }
            }
            ++n2;
        }
        for (ExpressionReturnValue value : this.dto.getValue()) {
            result.add(value.getToVariable());
        }
        return result;
    }

    protected String[] getToVariablesNames() {
        if (this.toVariables == null) {
            JRVariable[] vlist;
            ArrayList<String> res = new ArrayList<String>();
            JRVariable[] jRVariableArray = vlist = this.dto.getjConfig().getJasperDesign().getMainDataset().getVariables();
            int n = vlist.length;
            int n2 = 0;
            while (n2 < n) {
                JRVariable o = jRVariableArray[n2];
                JRDesignVariable jdVar = (JRDesignVariable)o;
                if (!jdVar.isSystemDefined()) {
                    res.add(jdVar.getName());
                }
                ++n2;
            }
            return res.toArray(new String[res.size()]);
        }
        return this.toVariables;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_RETURN_VALUE;
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ExpressionReturnValue val = (ExpressionReturnValue)element;
            switch (columnIndex) {
                case 0: {
                    if (val.getExpression() == null) {
                        return "";
                    }
                    return val.getExpression().getText();
                }
                case 1: {
                    return Misc.nvl((String)val.getToVariable());
                }
                case 2: {
                    if (val.getCalculation() == null) {
                        return "";
                    }
                    return val.getCalculation().getName();
                }
                case 3: {
                    return Misc.nvl((String)val.getIncrementerFactoryClassName());
                }
            }
            return "";
        }
    }
}

