/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class DeleteElementCommand
extends Command {
    protected JasperDesign jDesign;
    private JRElementGroup jrGroup;
    private JRDesignElement jrElement;
    private ANode nodeElement;
    private ANode nodeParent;
    private int elementPosition = 0;
    private JRPropertiesHolder[] pholder;
    private JSSCompoundCommand commands;
    private LayoutCommand lCmd;

    public DeleteElementCommand(MGraphicElement srcNode) {
        this.jrElement = srcNode.getValue();
        this.jrGroup = this.jrElement.getElementGroup();
        this.jDesign = srcNode.getJasperDesign();
        this.nodeElement = srcNode;
        this.nodeParent = srcNode.getParent();
        if (this.nodeParent instanceof IContainerLayout) {
            this.pholder = ((IContainerLayout)((Object)this.nodeParent)).getPropertyHolder();
        }
    }

    public void execute() {
        if (this.jrGroup != null && this.jrGroup.getChildren() != null) {
            this.elementPosition = this.jrGroup.getChildren().indexOf(this.jrElement);
            if (this.elementPosition != -1) {
                if (this.jrGroup instanceof JRDesignElementGroup) {
                    ((JRDesignElementGroup)this.jrGroup).removeElement(this.jrElement);
                } else if (this.jrGroup instanceof JRDesignFrame) {
                    ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.jrElement);
                }
                if (this.commands == null) {
                    List<Command> commandsList = JaspersoftStudioPlugin.getPostDeleteManager().postDelete(this.nodeElement, this.nodeParent);
                    INode startingNode = null;
                    if (commandsList != null && !commandsList.isEmpty()) {
                        this.commands = new JSSCompoundCommand(JSSCompoundCommand.getMainNode(startingNode));
                        for (Command c : commandsList) {
                            this.commands.add(c);
                        }
                    }
                }
                if (this.commands != null) {
                    this.commands.execute();
                }
                if (this.jrGroup instanceof JRPropertiesHolder) {
                    String uuid = null;
                    if (this.jrGroup instanceof JRBaseElement) {
                        uuid = ((JRBaseElement)this.jrGroup).getUUID().toString();
                    }
                    Dimension d = new Dimension(0, 0);
                    if (this.jrGroup instanceof JRCommonElement) {
                        d = LayoutManager.getPaddedSize((JRCommonElement)this.jrGroup);
                    }
                    if (this.jrGroup instanceof JRDesignBand) {
                        int w = this.jDesign.getPageWidth() - this.jDesign.getLeftMargin() - this.jDesign.getRightMargin();
                        d.setSize(new Dimension(w, ((JRDesignBand)this.jrGroup).getHeight()));
                    }
                    if (this.lCmd == null) {
                        ILayout layout = LayoutManager.getLayout(this.pholder, this.jDesign, uuid);
                        this.lCmd = new LayoutCommand(this.jDesign, this.jrGroup, layout, d);
                        this.lCmd.execute();
                    }
                }
            }
        }
    }

    public boolean canUndo() {
        if (this.elementPosition == -1) {
            return true;
        }
        return this.jrGroup != null && this.jrElement != null;
    }

    public void undo() {
        if (this.elementPosition != -1) {
            if (this.commands != null) {
                this.commands.undo();
            }
            if (this.lCmd != null) {
                this.lCmd.undo();
            }
            if (this.jrGroup != null && this.jrGroup.getChildren() != null) {
                if (this.jrGroup instanceof JRDesignElementGroup) {
                    if (this.elementPosition > ((JRDesignElementGroup)this.jrGroup).getChildren().size()) {
                        ((JRDesignElementGroup)this.jrGroup).addElement(this.jrElement);
                    } else {
                        ((JRDesignElementGroup)this.jrGroup).addElement(this.elementPosition, this.jrElement);
                    }
                } else if (this.jrGroup instanceof JRDesignFrame) {
                    if (this.elementPosition > ((JRDesignFrame)this.jrGroup).getChildren().size()) {
                        ((JRDesignFrame)this.jrGroup).addElement((JRElement)this.jrElement);
                    } else {
                        ((JRDesignFrame)this.jrGroup).addElement(this.elementPosition, (JRElement)this.jrElement);
                    }
                }
            }
        }
    }
}

