/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.MGraphicElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class OrphanElementCommand
extends Command {
    private int index;
    private JRDesignElement jrElement;
    private JRElementGroup jrGroup;
    private Point location;
    private ANode parent;

    public OrphanElementCommand(ANode parent, MGraphicElement child) {
        super(Messages.common_orphan_child);
        this.jrElement = child.getValue();
        this.parent = parent;
        this.jrGroup = parent instanceof IGroupElement ? ((IGroupElement)((Object)parent)).getJRElementGroup() : (JRElementGroup)parent.getValue();
    }

    public void execute() {
        this.location = new Point(this.jrElement.getX(), this.jrElement.getY());
        this.index = this.jrGroup.getChildren().indexOf(this.jrElement);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement(this.jrElement);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.jrElement);
        }
        LayoutManager.layoutContainer(this.parent);
    }

    public void undo() {
        this.jrElement.setX(this.location.x);
        this.jrElement.setY(this.location.y);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            if (this.index > ((JRDesignElementGroup)this.jrGroup).getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.index, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            if (this.index > ((JRDesignFrame)this.jrGroup).getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElement((JRElement)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElement(this.index, (JRElement)this.jrElement);
            }
        }
        LayoutManager.layoutContainer(this.parent);
    }
}

