/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class RenameDatasetObjectNameCommand
extends Command {
    private String newvalue;
    private String oldvalue;
    private String type;
    private String type1;
    private JasperDesign jd;
    private JasperReportsContext jContext;
    private JRDataset dataset;
    private Set<JRDesignExpression> cexpr = new HashSet<JRDesignExpression>();
    private ANode node;

    public RenameDatasetObjectNameCommand(MField mfield, String oldvalue) {
        this.node = mfield;
        this.jd = mfield.getJasperDesign();
        this.jContext = mfield.getJasperConfiguration();
        this.dataset = ModelUtils.getDataset(mfield);
        this.type = "\\$F\\{";
        this.type1 = "$F{";
        this.newvalue = mfield.getValue().getName();
        this.oldvalue = oldvalue;
    }

    public RenameDatasetObjectNameCommand(MVariable mvar, String oldvalue) {
        this.node = mvar;
        this.jd = mvar.getJasperDesign();
        this.jContext = mvar.getJasperConfiguration();
        this.dataset = ModelUtils.getDataset(mvar);
        this.type = "\\$V\\{";
        this.type1 = "$V{";
        this.newvalue = mvar.getValue().getName();
        this.oldvalue = oldvalue;
    }

    public RenameDatasetObjectNameCommand(MParameter mparam, String oldvalue) {
        this.node = mparam;
        this.jd = mparam.getJasperDesign();
        this.jContext = mparam.getJasperConfiguration();
        this.dataset = ModelUtils.getDataset(mparam);
        this.type = "\\$P\\{";
        this.type1 = "$P{";
        this.newvalue = mparam.getValue().getName();
        this.oldvalue = oldvalue;
    }

    private void setModelRefresh(List<INode> childerns) {
        for (INode child : childerns) {
            this.setModelRefresh(child.getChildren());
        }
    }

    public void execute() {
        this.cexpr.clear();
        if (this.dataset != null) {
            JRExpressionCollector reportCollector = JRExpressionCollector.collector((JasperReportsContext)this.jContext, (JRReport)this.jd);
            JRExpressionCollector datasetCollector = reportCollector.getCollector(this.dataset);
            List datasetExpressions = datasetCollector.getExpressions();
            boolean modelAlreadyInitialized = false;
            for (JRExpression expr : datasetExpressions) {
                String s = expr.getText();
                if (s == null || s.length() <= 4 || !s.contains(String.valueOf(this.type1) + this.oldvalue + "}")) continue;
                if (!modelAlreadyInitialized) {
                    this.setModelRefresh(this.node.getRoot().getChildren());
                    modelAlreadyInitialized = true;
                }
                s = s.replaceAll(String.valueOf(this.type) + Pattern.quote(this.oldvalue) + "}", String.valueOf(this.type) + Matcher.quoteReplacement(this.newvalue) + "}");
                JRDesignExpression dexpr = (JRDesignExpression)expr;
                dexpr.setText(s);
                this.cexpr.add((JRDesignExpression)expr);
            }
            this.doSetQuery(this.oldvalue, this.newvalue);
        }
    }

    protected void doSetQuery(String oldVal, String newVal) {
        JRDesignQuery query;
        if (this.type1.equals("$P{") && (query = (JRDesignQuery)this.dataset.getQuery()) != null) {
            String q = query.getText();
            query.setText(q.replaceAll(String.valueOf(this.type) + Pattern.quote(oldVal) + "}", String.valueOf(this.type) + Matcher.quoteReplacement(newVal) + "}"));
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.dataset != null) {
            for (JRDesignExpression de : this.cexpr) {
                de.setText(de.getText().replaceAll(Pattern.quote(this.newvalue), Matcher.quoteReplacement(this.oldvalue)));
            }
            this.doSetQuery(this.newvalue, this.oldvalue);
        }
    }
}

