/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.gef.commands.Command;

public class ReorderElementCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignElement jrElement;
    private JRElementGroup jrGroup;
    private ANode parent;
    private Command layoutCommand = null;

    public ReorderElementCommand(MGraphicElement child, ANode parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = this.jrElement.getElementGroup();
        this.parent = parent;
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getChildren().indexOf(this.jrElement);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement(this.jrElement);
            if (this.newIndex < 0 || this.newIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.newIndex, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.jrElement);
            if (this.newIndex < 0 || this.newIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElement((JRElement)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElement(this.newIndex, (JRElement)this.jrElement);
            }
        }
        this.layoutCommand = LayoutManager.createRelayoutCommand(this.parent);
        if (this.layoutCommand != null) {
            this.layoutCommand.execute();
        }
    }

    public void undo() {
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement(this.jrElement);
            if (this.oldIndex < 0 || this.oldIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElement(this.oldIndex, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.jrElement);
            if (this.oldIndex < 0 || this.oldIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElement((JRElement)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElement(this.oldIndex, (JRElement)this.jrElement);
            }
        }
        if (this.layoutCommand != null) {
            this.layoutCommand.undo();
        }
    }
}

