/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset;

import com.jaspersoft.studio.data.DataAdapterUtils;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.File;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class SelectDefaultDatasetPage
extends JSSHelpWizardPage {
    private Text pathText;
    private Button browseWorkspace;
    private Button browseFilesystem;
    private Button btnWorkspaceResource;
    private Button btnAbsolutePath;
    private Button btnUrlRemote;
    private Button btnCustom;
    private Group grpOptions;
    private String path = null;
    private Label descriptionLabel;
    private IFile context;

    public SelectDefaultDatasetPage(IFile context, String intialPath) {
        super("defaultDAPage");
        this.setTitle(this.getDialogTitle());
        this.setDescription(Messages.SelectDefaultDatasetDialog_dialogDescription);
        this.context = context;
        if (intialPath != null) {
            this.path = intialPath;
        }
    }

    protected String getDialogTitle() {
        return Messages.SelectDefaultDatasetDialog_dialogTitle;
    }

    protected String[] getModesAndHeaderTitles() {
        return new String[]{Messages.SelectDefaultDatasetDialog_modeLabel, Messages.SelectDefaultDatasetDialog_workspaceOption, Messages.SelectDefaultDatasetDialog_absoluteOption, Messages.SelectDefaultDatasetDialog_urlOption, Messages.SelectDefaultDatasetDialog_noDAOption, Messages.SelectDefaultDatasetPage_customDAAction};
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        container.setLayoutData((Object)new GridData(1808));
        String[] modesAndHeaderTitles = this.getModesAndHeaderTitles();
        Group grpSelectionMode = new Group(container, 0);
        grpSelectionMode.setText(modesAndHeaderTitles[0]);
        grpSelectionMode.setLayout((Layout)new GridLayout(1, false));
        grpSelectionMode.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.btnWorkspaceResource = new Button((Composite)grpSelectionMode, 16);
        this.btnWorkspaceResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.pathText.setText("");
                SelectDefaultDatasetPage.this.changeSelectionMode();
                SelectDefaultDatasetPage.this.path = SelectDefaultDatasetPage.this.pathText.getText();
                SelectDefaultDatasetPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.btnWorkspaceResource.setText(modesAndHeaderTitles[1]);
        this.btnAbsolutePath = new Button((Composite)grpSelectionMode, 16);
        this.btnAbsolutePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.pathText.setText("");
                SelectDefaultDatasetPage.this.changeSelectionMode();
                SelectDefaultDatasetPage.this.path = SelectDefaultDatasetPage.this.pathText.getText();
                SelectDefaultDatasetPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.btnAbsolutePath.setText(modesAndHeaderTitles[2]);
        this.btnUrlRemote = new Button((Composite)grpSelectionMode, 16);
        this.btnUrlRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.pathText.setText("");
                SelectDefaultDatasetPage.this.changeSelectionMode();
                SelectDefaultDatasetPage.this.path = SelectDefaultDatasetPage.this.pathText.getText();
                SelectDefaultDatasetPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.btnUrlRemote.setText(modesAndHeaderTitles[3]);
        this.btnCustom = new Button((Composite)grpSelectionMode, 16);
        this.btnCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.pathText.setText("");
                SelectDefaultDatasetPage.this.changeSelectionMode();
                SelectDefaultDatasetPage.this.path = SelectDefaultDatasetPage.this.pathText.getText();
                SelectDefaultDatasetPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.btnCustom.setText(modesAndHeaderTitles[5]);
        this.createOptionsPanel(container);
        if (this.path == null || this.path.trim().isEmpty()) {
            this.btnWorkspaceResource.setSelection(true);
            this.changeSelectionMode();
        } else {
            this.pathText.setText(this.path);
            File checkAbsolute = new File(this.path);
            if (checkAbsolute.exists()) {
                this.btnAbsolutePath.setSelection(true);
                this.changeSelectionMode();
            } else if (FileUtils.isValidURL((String)this.path)) {
                this.btnUrlRemote.setSelection(true);
                this.changeSelectionMode();
            } else {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.path);
                if (resource instanceof IFile && ((IFile)resource).exists()) {
                    this.btnWorkspaceResource.setSelection(true);
                    this.changeSelectionMode();
                } else {
                    this.btnCustom.setSelection(true);
                    this.changeSelectionMode();
                }
            }
        }
        this.getWizard().getContainer().updateButtons();
        this.setControl((Control)container);
    }

    private void createOptionsPanel(Composite container) {
        this.grpOptions = new Group(container, 0);
        this.grpOptions.setText(Messages.SelectDefaultDatasetPage_pathLabel);
        this.grpOptions.setLayout((Layout)new GridLayout(1, false));
        this.grpOptions.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.descriptionLabel = new Label((Composite)this.grpOptions, 0);
        this.descriptionLabel.setLayoutData((Object)new GridData(768));
        Composite controlContainer = new Composite((Composite)this.grpOptions, 0);
        controlContainer.setLayout((Layout)new GridLayout(3, false));
        controlContainer.setLayoutData((Object)new GridData(768));
        this.pathText = new Text(controlContainer, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDefaultDatasetPage.this.textModified();
            }
        });
        this.createWSSelectionContainer(controlContainer);
        this.createFSSelectionContainer(controlContainer);
    }

    private void changeSelectionMode() {
        if (this.btnAbsolutePath.getSelection()) {
            ((GridData)this.browseFilesystem.getLayoutData()).exclude = false;
            this.browseFilesystem.setVisible(true);
            ((GridData)this.browseWorkspace.getLayoutData()).exclude = true;
            this.browseWorkspace.setVisible(false);
        } else if (this.btnWorkspaceResource.getSelection()) {
            ((GridData)this.browseFilesystem.getLayoutData()).exclude = true;
            this.browseFilesystem.setVisible(false);
            ((GridData)this.browseWorkspace.getLayoutData()).exclude = false;
            this.browseWorkspace.setVisible(true);
        } else {
            ((GridData)this.browseFilesystem.getLayoutData()).exclude = true;
            this.browseFilesystem.setVisible(false);
            ((GridData)this.browseWorkspace.getLayoutData()).exclude = true;
            this.browseWorkspace.setVisible(false);
        }
        if (this.btnAbsolutePath.getSelection()) {
            this.descriptionLabel.setText(Messages.SelectDefaultDatasetDialog_absoluteLabel);
        } else if (this.btnWorkspaceResource.getSelection()) {
            this.descriptionLabel.setText(Messages.SelectDefaultDatasetDialog_workspaceLabel);
        } else if (this.btnUrlRemote.getSelection()) {
            this.descriptionLabel.setText(Messages.SelectDefaultDatasetDialog_urlLabel);
        } else if (this.btnCustom.getSelection()) {
            this.descriptionLabel.setText(Messages.SelectDefaultDatasetPage_customDADescription);
        }
        this.grpOptions.layout(true, true);
        this.getWizard().getContainer().updateButtons();
    }

    private void createWSSelectionContainer(Composite container) {
        this.browseWorkspace = new Button(container, 0);
        this.browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.selectDataAdapterFromWorkspace();
            }
        });
        GridData data = new GridData();
        data.exclude = true;
        this.browseWorkspace.setLayoutData((Object)data);
        this.browseWorkspace.setText(Messages.common_browse);
        this.browseWorkspace.setVisible(false);
    }

    private void createFSSelectionContainer(Composite container) {
        this.browseFilesystem = new Button(container, 0);
        this.browseFilesystem.setText(Messages.common_browse);
        this.browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDefaultDatasetPage.this.selectDataAdapterFromFilesystem();
            }
        });
        GridData data = new GridData();
        data.exclude = true;
        this.browseFilesystem.setLayoutData((Object)data);
        this.browseFilesystem.setVisible(false);
    }

    private void textModified() {
        if (this.btnAbsolutePath.getSelection()) {
            String daPath = this.pathText.getText().trim();
            this.path = daPath.replace(File.pathSeparatorChar, '/');
        } else {
            this.path = this.pathText.getText().trim();
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void selectDataAdapterFromWorkspace() {
        FilteredResourcesSelectionDialog fd = new FilteredResourcesSelectionDialog(UIUtils.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        fd.setInitialPattern("*.jrdax");
        if (fd.open() == 0) {
            IFile file = (IFile)fd.getFirstResult();
            String filepath = null;
            if (this.context != null && this.context.getProject().equals((Object)file.getProject())) {
                filepath = FileUtils.getFileRelativePath((IFile)this.context, (IFile)file);
            }
            if (filepath == null) {
                filepath = file.getLocation().toOSString();
            }
            filepath = filepath.toString().replace(File.pathSeparatorChar, '/');
            this.pathText.setText(filepath);
            this.path = filepath;
        }
    }

    private boolean isInWorkspace(String location) {
        IFile folderFile;
        Path path = new Path(location);
        try {
            folderFile = this.context.getParent().getFile((IPath)path);
            if (folderFile.exists()) {
                return true;
            }
        }
        catch (Exception exception) {}
        try {
            folderFile = this.context.getProject().getFile((IPath)path);
            if (folderFile.exists()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private void selectDataAdapterFromFilesystem() {
        Shell tmpShell = new Shell(UIUtils.getDisplay());
        FileDialog fd = new FileDialog(tmpShell);
        if (this.path == null || !new File(this.path).exists()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            fd.setFilterPath(root.getLocation().toOSString());
        } else {
            fd.setFilterPath(this.path);
        }
        fd.setFilterExtensions(DataAdapterUtils.FILTER_EXTENSIONS);
        String selection = fd.open();
        if (selection != null) {
            this.pathText.setText(selection);
        }
        tmpShell.dispose();
    }

    public String getDataAdapterPath() {
        return this.path;
    }

    public boolean isPageComplete() {
        if (this.btnAbsolutePath.getSelection()) {
            if (this.path == null || this.path.isEmpty()) {
                this.setMessage(Messages.SelectDefaultDatasetDialog_errorAbsoluteEmpty, 2);
            } else {
                File file = new File(this.path);
                if (!file.exists() || file.isDirectory()) {
                    this.setMessage(Messages.SelectDefaultDatasetDialog_warningAbsoluteNotFound, 2);
                } else {
                    this.setMessage(Messages.SelectDefaultDatasetDialog_dialogDescription);
                }
            }
        } else if (this.btnUrlRemote.getSelection()) {
            if (this.path == null || this.path.isEmpty()) {
                this.setMessage(Messages.SelectDefaultDatasetDialog_errorURLEmpty, 2);
            } else if (!FileUtils.isValidURL((String)this.path)) {
                this.setMessage(Messages.SelectDefaultDatasetDialog_errorURLInvalid, 2);
            } else {
                this.setMessage(Messages.SelectDefaultDatasetDialog_dialogDescription);
            }
        } else if (this.btnWorkspaceResource.getSelection()) {
            if (this.path == null || this.path.isEmpty()) {
                this.setMessage(Messages.SelectDefaultDatasetDialog_errorAbsoluteEmpty, 2);
            } else if (!this.isInWorkspace(this.path)) {
                this.setMessage(Messages.SelectDefaultDatasetDialog_warningAbsoluteNotFound, 2);
            } else {
                this.setMessage(Messages.SelectDefaultDatasetDialog_dialogDescription);
            }
        } else {
            this.setMessage(Messages.SelectDefaultDatasetDialog_dialogDescription);
        }
        return true;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_DEFAULT_DATA_ADAPTER;
    }
}

