/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field;

import com.jaspersoft.studio.editor.outline.actions.field.SortFieldsAction;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.field.MFieldsContainer;
import com.jaspersoft.studio.model.util.EditPartVisitor;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class FieldUtils {
    public static void buildFieldsTree(MFields parentNode, final TreeEditPart treePart) {
        ISelection oldSelection = treePart.getViewer().getSelection();
        final ArrayList<ANode> oldNodes = new ArrayList<ANode>();
        for (Object obj : ((StructuredSelection)oldSelection).toList()) {
            MField mf;
            if (!(obj instanceof EditPart)) continue;
            ANode m = (ANode)((EditPart)obj).getModel();
            if (m instanceof MFieldsContainer && (mf = (MField)new ModelVisitor<MField>((INode)m){

                @Override
                public boolean visit(INode n) {
                    if (n instanceof MField) {
                        this.setObject((MField)n);
                        this.stop();
                    }
                    return true;
                }
            }.getObject()) != null) {
                oldNodes.add(mf);
            }
            oldNodes.add(m);
        }
        final LinkedHashMap map = new LinkedHashMap();
        final HashMap<String, String> pLabels = new HashMap<String, String>();
        new ModelVisitor<Object>((INode)parentNode){

            @Override
            public boolean visit(INode n) {
                if (n instanceof MField) {
                    ArrayList<MField> fs;
                    String plabel;
                    JRDesignField f = ((MField)n).getValue();
                    String path = Misc.nvl((String)f.getPropertiesMap().getProperty("com.jaspersoft.studio.field.tree.path"));
                    if (!path.isEmpty() && !Misc.isNullOrEmpty((String)(plabel = FieldUtils.getLastName(path)))) {
                        pLabels.put(path, plabel);
                    }
                    if ((fs = (ArrayList<MField>)map.get(path)) == null) {
                        fs = new ArrayList<MField>();
                    }
                    fs.add((MField)n);
                    map.put(path, fs);
                }
                return true;
            }
        };
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        if (SortFieldsAction.areFieldsSorted(parentNode.getJasperConfiguration())) {
            for (List list : map.values()) {
                if (list == null) continue;
                Collections.sort(list, new Comparator<INode>(){

                    @Override
                    public int compare(INode o1, INode o2) {
                        MField var1 = (MField)o1;
                        MField var2 = (MField)o2;
                        String nameVar1 = (String)var1.getPropertyActualValue("name");
                        String nameVar2 = (String)var2.getPropertyActualValue("name");
                        return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                    }
                });
            }
        }
        parentNode.removeChildren();
        HashMap<String, MFields> parents = new HashMap<String, MFields>();
        ArrayList mkeys = new ArrayList(map.keySet());
        Collections.sort(mkeys);
        Iterator iterator = mkeys.iterator();
        while (iterator.hasNext()) {
            String key;
            String pkey = key = (String)iterator.next();
            int indx = key.lastIndexOf(".");
            if (indx > 0) {
                pkey = key.substring(0, indx);
            }
            MFields parent = null;
            for (String pk : parents.keySet()) {
                if (!pk.equals(pkey) && !pkey.startsWith(String.valueOf(pk) + ".")) continue;
                parent = (MFields)parents.get(pk);
            }
            if (parent == null) {
                parent = parentNode;
            }
            if (!Misc.isNullOrEmpty((String)key)) {
                MFieldsContainer mfc = FieldUtils.getMFieldContainer(oldNodes, key);
                if (mfc != null) {
                    oldNodes.add(mfc);
                    parent = mfc;
                    mfc.removeChildren();
                } else {
                    String[] pkeyArray;
                    String[] parray;
                    String k = "";
                    if (parent instanceof MFieldsContainer) {
                        k = ((MFieldsContainer)parent).getKey();
                    }
                    if ((parray = k.isEmpty() ? new String[]{} : k.split("\\.")).length < (pkeyArray = key.split("\\.")).length - 1) {
                        int i = parray.length;
                        while (i < pkeyArray.length - 1) {
                            String ikey = "";
                            String del = "";
                            int j = 0;
                            while (j <= i) {
                                ikey = String.valueOf(ikey) + del + pkeyArray[j];
                                del = ".";
                                ++j;
                            }
                            parent = new MFieldsContainer(parent, parentNode.getValue(), pLabels, ikey);
                            parents.put(ikey, parent);
                            ++i;
                        }
                    }
                    parent = new MFieldsContainer(parent, parentNode.getValue(), pLabels, key);
                }
            }
            parents.put(key, parent);
            for (MField f : (List)map.get(key)) {
                f.setParent(parent, -1);
            }
        }
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (treePart == null || treePart.getViewer() == null) {
                    return;
                }
                final ArrayList parts = new ArrayList();
                new EditPartVisitor<Boolean>(treePart.getViewer().getContents()){

                    @Override
                    public boolean visit(EditPart n) {
                        if (oldNodes.contains(n.getModel())) {
                            parts.add(n);
                        }
                        return true;
                    }
                };
                treePart.getViewer().setSelection((ISelection)new StructuredSelection(parts));
            }
        });
    }

    private static MFieldsContainer getMFieldContainer(List<ANode> nodes, String key) {
        int i = 0;
        while (i < nodes.size()) {
            ANode n = nodes.get(i);
            if (n instanceof MFieldsContainer && ((MFieldsContainer)n).getKey().equals(key)) {
                return (MFieldsContainer)n;
            }
            ++i;
        }
        return null;
    }

    private static String getLastName(String path) {
        int indx = path.lastIndexOf(".");
        if (indx > 0) {
            path = path.substring(indx + 1);
        }
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return path;
        }
    }

    public static void flatTree(MFields parentNode) {
        final ArrayList fields = new ArrayList();
        Boolean refresh = (Boolean)new ModelVisitor<Boolean>((INode)parentNode){

            @Override
            public boolean visit(INode n) {
                if (n instanceof MFields) {
                    this.setObject(true);
                }
                if (n instanceof MField) {
                    fields.add((MField)n);
                }
                return true;
            }
        }.getObject();
        if (refresh != null && refresh.booleanValue()) {
            parentNode.removeChildren();
            for (MField f : fields) {
                f.setParent(parentNode, -1);
            }
        }
    }

    public static List<MField> getFields(MFields parentNode) {
        final ArrayList<MField> fields = new ArrayList<MField>();
        new ModelVisitor<Object>((INode)parentNode){

            @Override
            public boolean visit(INode n) {
                if (n instanceof MField) {
                    fields.add((MField)n);
                }
                return true;
            }
        }.getObject();
        return fields;
    }

    public static List<JRField> getFields(JRDesignDataset ds, String key) {
        ArrayList<JRField> fields = new ArrayList<JRField>();
        JRField[] jRFieldArray = ds.getFields();
        int n = jRFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRField f = jRFieldArray[n2];
            String k = f.getPropertiesMap().getProperty("com.jaspersoft.studio.field.tree.path");
            if (!Misc.isNullOrEmpty((String)k) && k.startsWith(key)) {
                fields.add(f);
            }
            ++n2;
        }
        return fields;
    }
}

