/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.field.FieldNameValidator;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeComboCellEditor;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPClassTypeCombo;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MField
extends APropertyNode
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static FieldNameValidator validator;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("field");
        }
        return iconDescriptor;
    }

    public MField() {
    }

    public MField(ANode parent, JRDesignField jfRield, int newIndex) {
        super(parent, newIndex);
        this.setValue(jfRield);
    }

    public JRDesignField getValue() {
        return (JRDesignField)super.getValue();
    }

    @Override
    public String getDisplayText() {
        return this.getValue().getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MField.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        String tt = MField.getIconDescriptor().getToolTip();
        String plabel = this.getValue().getPropertiesMap().getProperty("com.jaspersoft.studio.field.label");
        if (!Misc.isNullOrEmpty((String)plabel)) {
            tt = String.valueOf(tt) + "\nLabel: " + plabel;
        }
        return tt;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateNameValidator();
    }

    protected void updateNameValidator() {
        if (validator == null) {
            validator = new FieldNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateNameValidator();
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor("propertyExpressions", Messages.MGraphicElement_property_expressions);
        propertiesD.setDescription(Messages.MGraphicElement_property_expressions_description);
        desc.add((IPropertyDescriptor)propertiesD);
        propertiesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#property"));
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MField_name_description);
        desc.add((IPropertyDescriptor)nameD);
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor((Object)"valueClassName", Messages.common_class, ClassTypeComboCellEditor.DEFAULT_ITEMS){

            @Override
            public ASPropertyWidget<RWComboBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                SPClassTypeCombo<RWComboBoxPropertyDescriptor> classNameWidget = new SPClassTypeCombo<RWComboBoxPropertyDescriptor>(parent, section, this);
                classNameWidget.setClassesOfType(this.classes);
                classNameWidget.setReadOnly(this.readOnly);
                return classNameWidget;
            }
        };
        classD.setDescription(Messages.MField_class_description);
        desc.add((IPropertyDescriptor)classD);
        classD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#field_class"));
        NTextPropertyDescriptor descriptionD = new NTextPropertyDescriptor("description", Messages.common_description);
        descriptionD.setDescription(Messages.MField_description_description);
        desc.add((IPropertyDescriptor)descriptionD);
        descriptionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#fieldDescription"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#field");
    }

    public Object getPropertyValue(Object id) {
        JRDesignField jrField = this.getValue();
        if (id.equals("name")) {
            return jrField.getName();
        }
        if (id.equals("valueClassName")) {
            return jrField.getValueClassName();
        }
        if (id.equals("description")) {
            return jrField.getDescription();
        }
        if (id.equals("propertyExpressions")) {
            JRPropertyExpression[] propertyExpressions = jrField.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            ExpressionContext ec = ModelUtils.getExpressionContext(this);
            JRDesignDataset d = ModelUtils.getDataset(this);
            if (d != null) {
                if (d.getQuery() != null) {
                    ec.getJasperReportsConfiguration().put("com.jaspersoft.studio.dataset.language", d.getQuery().getLanguage());
                } else {
                    ec.getJasperReportsConfiguration().remove("com.jaspersoft.studio.dataset.language");
                }
            }
            return new PropertyExpressionsDTO(propertyExpressions, MField.getPropertiesMapClone(jrField), this.getValue(), ec);
        }
        if (id.equals("PROPERTY_MAP")) {
            return MField.getPropertiesMapClone(jrField);
        }
        return null;
    }

    public static JRPropertiesMap getPropertiesMapClone(JRDesignField jrField) {
        JRPropertiesMap propertiesMap = jrField.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            JRDesignField jrField = this.getValue();
            JRDesignDataset d = ModelUtils.getDataset(this);
            if (d != null) {
                d.getFieldsMap().remove(evt.getOldValue());
                d.getFieldsMap().put(jrField.getName(), jrField);
            }
        }
        super.propertyChange(evt);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignField jrField = this.getValue();
        if (id.equals("name")) {
            if (!value.equals("")) {
                JRDesignDataset d = ModelUtils.getDataset(this);
                for (JRField p : d.getFieldsList()) {
                    if (p == jrField || !p.getName().equals(value)) continue;
                    return;
                }
                jrField.setName((String)value);
            }
        } else if (id.equals("valueClassName")) {
            jrField.setValueClassName((String)value);
        } else if (id.equals("description")) {
            if (StringUtils.isNullOrEmpty((String)((String)value))) {
                jrField.setDescription(null);
            } else {
                jrField.setDescription((String)value);
            }
        } else if (id.equals("propertyExpressions")) {
            if (value instanceof PropertyExpressionsDTO) {
                PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
                JRPropertyExpression[] expr = jrField.getPropertyExpressions();
                if (expr != null) {
                    JRPropertyExpression[] jRPropertyExpressionArray = expr;
                    int n = expr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRPropertyExpression ex = jRPropertyExpressionArray[n2];
                        jrField.removePropertyExpression(ex);
                        ++n2;
                    }
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (!p.isExpression()) continue;
                    JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                    newExp.setName(p.getName());
                    newExp.setValueExpression(p.getValueAsExpression());
                    jrField.addPropertyExpression((JRPropertyExpression)newExp);
                }
                JRPropertiesMap originalMap = jrField.getPropertiesMap().cloneProperties();
                String[] names = jrField.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    jrField.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    jrField.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
                this.firePropertyChange(new PropertyChangeEvent(jrField, "PROPERTY_MAP", originalMap, jrField.getPropertiesMap()));
            }
        } else if (id.equals("PROPERTY_MAP")) {
            JRPropertiesMap v = (JRPropertiesMap)value;
            String[] names = jrField.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrField.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            names = v.getPropertyNames();
            i = 0;
            while (i < names.length) {
                jrField.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                ++i;
            }
            this.getPropertyChangeSupport().firePropertyChange("PROPERTY_MAP", false, true);
        }
    }

    public static JRDesignField createJRField(JRDesignDataset jrDataset) {
        JRDesignField jrDesignField = new JRDesignField();
        jrDesignField.setName(ModelUtils.getDefaultName(jrDataset.getFieldsMap(), "Field_"));
        return jrDesignField;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MFields) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        JRDesignDataset dataSet = ModelUtils.getDataset(this);
        JasperReportsConfiguration conf = this.getJasperConfiguration();
        if (dataSet != null && conf != null) {
            return new ExpressionContext(dataSet, conf);
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (ExpressionContext.class.equals((Object)adapter)) {
            return this.getExpressionContext();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

