/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.field.command.ReorderFieldCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateFieldCommand
extends Command {
    private JRDesignField jrField;
    private JRDesignDataset jrDataSet;
    private int index;
    private ReorderFieldCommand rc;

    public CreateFieldCommand(MFields destNode, MField srcNode, int index) {
        this.jrDataSet = destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrField = srcNode.getValue();
        }
    }

    public CreateFieldCommand(JRDesignDataset destNode, JRDesignField srcNode, int index) {
        this.jrDataSet = destNode;
        this.index = index;
        if (srcNode != null) {
            this.jrField = srcNode;
        }
    }

    public void execute() {
        block11: {
            if (this.rc != null) {
                this.rc.execute();
                return;
            }
            if (this.jrField == null) {
                this.jrField = MField.createJRField(this.jrDataSet);
            }
            if (this.jrField != null) {
                if (this.jrDataSet.getFieldsList().contains(this.jrField)) {
                    this.rc = new ReorderFieldCommand(this.jrField, this.jrDataSet, this.index);
                    this.rc.execute();
                    return;
                }
                if (this.index < 0) {
                    this.index = this.jrDataSet.getFieldsList().size();
                }
                try {
                    if (this.index < 0 || this.index > this.jrDataSet.getFieldsList().size()) {
                        this.jrDataSet.addField((JRField)this.jrField);
                    } else {
                        this.jrDataSet.addField(this.index, (JRField)this.jrField);
                    }
                    SelectionHelper.setOutlineSelection(this.jrField);
                }
                catch (JRException e) {
                    InputDialog dlg;
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("Duplicate declaration")) break block11;
                    String defaultName = "CopyOf_" + this.jrField.getName();
                    if (this.jrDataSet.getFieldsMap().containsKey(defaultName)) {
                        defaultName = ModelUtils.getDefaultName(this.jrDataSet.getFieldsMap(), String.valueOf(defaultName) + "_");
                    }
                    if ((dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateFieldCommand_field_name, Messages.CreateFieldCommand_field_name_text_dialog, defaultName, null)).open() == 0) {
                        this.jrField.setName(dlg.getValue());
                        this.execute();
                    }
                    return;
                }
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.rc != null) {
            this.rc.undo();
        } else {
            this.jrDataSet.removeField((JRField)this.jrField);
        }
    }
}

