/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field.command;

import com.jaspersoft.studio.model.command.ADatasetObjectDeleteCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public class DeleteFieldCommand
extends ADatasetObjectDeleteCommand {
    private JRDesignField jrField;
    private JRSortField jrSortField;
    private int oldSortFieldindex = 0;

    public DeleteFieldCommand(MFields destNode, MField srcNode) {
        this(srcNode.getJasperConfiguration(), destNode.getValue(), srcNode.getValue(), null);
    }

    public DeleteFieldCommand(JasperReportsConfiguration jContext, JRDesignDataset destNode, JRDesignField srcNode, Boolean canceled) {
        super(canceled);
        this.jContext = jContext;
        this.jd = jContext.getJasperDesign();
        this.jrDataset = destNode;
        this.jrField = srcNode;
        this.objectName = "$F{" + this.jrField.getName() + "}";
    }

    public void execute() {
        this.canceled = Boolean.FALSE;
        this.elementPosition = this.jrDataset.getFieldsList().indexOf(this.jrField);
        this.jrDataset.removeField((JRField)this.jrField);
        if (this.jrSortField == null) {
            for (JRSortField sf : this.jrDataset.getSortFieldsList()) {
                if (!sf.getType().equals((Object)SortFieldTypeEnum.FIELD) || !sf.getName().equals(this.jrField.getName())) continue;
                this.jrSortField = sf;
                break;
            }
        }
        if (this.jrSortField != null) {
            this.oldSortFieldindex = this.jrDataset.getSortFieldsList().indexOf(this.jrSortField);
            this.jrDataset.removeSortField(this.jrSortField);
        }
    }

    public boolean canUndo() {
        return this.jrDataset != null && this.jrField != null;
    }

    public void undo() {
        if (this.canceled == null || this.canceled.booleanValue()) {
            return;
        }
        try {
            if (this.elementPosition < 0 || this.elementPosition > this.jrDataset.getFieldsList().size()) {
                this.jrDataset.addField((JRField)this.jrField);
            } else {
                this.jrDataset.addField(this.elementPosition, (JRField)this.jrField);
            }
            if (this.jrSortField != null) {
                if (this.oldSortFieldindex >= 0 && this.oldSortFieldindex < this.jrDataset.getSortFieldsList().size()) {
                    this.jrDataset.addSortField(this.oldSortFieldindex, this.jrSortField);
                } else {
                    this.jrDataset.addSortField(this.jrSortField);
                }
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

