/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.genericElement;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.genericElement.ParameterPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MGenericElement
extends MGraphicElement {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_NAMESPACE = "namespace";
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;
    private IPropertyDescriptor[] descriptors;
    private RComboBoxPropertyDescriptor evaluationGroupNameD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("generic");
        }
        return iconDescriptor;
    }

    public MGenericElement() {
    }

    public MGenericElement(ANode parent, JRDesignGenericElement jrCrosstab, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrCrosstab);
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MGenericElement.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MGenericElement.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MGenericElement.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        evaluationTimeD = new NamedEnumPropertyDescriptor<EvaluationTimeEnum>("evaluationTime", Messages.common_evaluation_time, EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MGenericElement_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        this.evaluationGroupNameD = new RComboBoxPropertyDescriptor("evaluationGroupName", Messages.MGenericElement_evaluation_group_name, new String[]{""});
        this.evaluationGroupNameD.setDescription(Messages.MGenericElement_evaluation_group_name_description);
        desc.add((IPropertyDescriptor)this.evaluationGroupNameD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#genericElement");
        NTextPropertyDescriptor nameD = new NTextPropertyDescriptor(PROPERTY_NAME, Messages.MGenericElement_generic_type_name);
        nameD.setDescription(Messages.MGenericElement_generic_type_name_description);
        desc.add((IPropertyDescriptor)nameD);
        NTextPropertyDescriptor nameSpaceD = new NTextPropertyDescriptor(PROPERTY_NAMESPACE, Messages.MGenericElement_generic_type_namespace);
        nameSpaceD.setDescription(Messages.MGenericElement_generic_type_namespace_description);
        desc.add((IPropertyDescriptor)nameSpaceD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#genericElementType");
        ParameterPropertyDescriptor parametersD = new ParameterPropertyDescriptor("parameters", Messages.common_parameters);
        parametersD.setDescription(Messages.MGenericElement_parameters_description);
        desc.add((IPropertyDescriptor)parametersD);
        parametersD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#genericElementParameter"));
        parametersD.setCategory(Messages.MGenericElement_generic_element_properties_category);
        nameD.setCategory(Messages.MGenericElement_generic_element_properties_category);
        nameSpaceD.setCategory(Messages.MGenericElement_generic_element_properties_category);
        evaluationTimeD.setCategory(Messages.MGenericElement_generic_element_properties_category);
        this.evaluationGroupNameD.setCategory(Messages.MGenericElement_generic_element_properties_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("evaluationTime", new DefaultValue(EvaluationTimeEnum.NOW, false));
        return defaultsMap;
    }

    @Override
    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evaluationGroupNameD != null) {
            this.evaluationGroupNameD.setItems(items);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignGenericElement jrElement = (JRDesignGenericElement)this.getValue();
        if (id.equals("evaluationTime")) {
            return jrElement.getEvaluationTimeValue();
        }
        if (id.equals("evaluationGroupName")) {
            return jrElement.getEvaluationGroupName();
        }
        JRGenericElementType genericType = jrElement.getGenericType();
        if (genericType != null) {
            if (id.equals(PROPERTY_NAME)) {
                return genericType.getName();
            }
            if (id.equals(PROPERTY_NAMESPACE)) {
                return genericType.getNamespace();
            }
        }
        if (id.equals("parameters")) {
            return jrElement.getParameters();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignGenericElement jrElement = (JRDesignGenericElement)this.getValue();
        JRGenericElementType genericType = jrElement.getGenericType();
        if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            jrElement.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                jrElement.setEvaluationGroupName(null);
            }
        } else if (id.equals("evaluationGroupName")) {
            jrElement.setEvaluationGroupName(ModelUtils.getGroupNameForProperty(value));
        } else if (id.equals("parameters")) {
            JRGenericElementParameter prm;
            int n;
            int n2;
            JRGenericElementParameter[] jRGenericElementParameterArray;
            JRGenericElementParameter[] oldParameters = jrElement.getParameters();
            JRGenericElementParameter[] newParameters = (JRGenericElementParameter[])value;
            if (oldParameters != null) {
                jRGenericElementParameterArray = oldParameters;
                n2 = oldParameters.length;
                n = 0;
                while (n < n2) {
                    prm = jRGenericElementParameterArray[n];
                    jrElement.removeParameter(prm);
                    ++n;
                }
            }
            if (newParameters != null) {
                jRGenericElementParameterArray = newParameters;
                n2 = newParameters.length;
                n = 0;
                while (n < n2) {
                    prm = jRGenericElementParameterArray[n];
                    jrElement.addParameter(prm);
                    ++n;
                }
            }
        } else if (id.equals(PROPERTY_NAME)) {
            String namespace = genericType != null ? genericType.getNamespace() : "";
            jrElement.setGenericType(new JRGenericElementType(namespace, (String)value));
        } else if (id.equals(PROPERTY_NAMESPACE)) {
            String name = genericType != null ? genericType.getName() : "";
            jrElement.setGenericType(new JRGenericElementType((String)value, name));
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignGenericElement el = new JRDesignGenericElement((JRDefaultStyleProvider)jasperDesign);
        el.setGenericType(new JRGenericElementType(PROPERTY_NAMESPACE, PROPERTY_NAME));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)el);
        }
        return el;
    }
}

