/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.MGroups;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateGroupCommand
extends Command {
    protected JRDesignGroup jrGroup;
    protected JRDesignDataset jrDataSet;
    private int index;
    protected JasperDesign jrDesign;

    public CreateGroupCommand(MReport destNode, MGroup srcNode, int index) {
        this.jrDataSet = (JRDesignDataset)destNode.getJasperDesign().getMainDataset();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrGroup = (JRDesignGroup)srcNode.getValue();
        }
        this.jrDesign = destNode.getJasperDesign();
    }

    public CreateGroupCommand(MGroups destNode, MGroup srcNode, int index) {
        this.jrDataSet = (JRDesignDataset)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrGroup = (JRDesignGroup)srcNode.getValue();
        }
    }

    protected void createObject() {
        if (this.jrGroup == null) {
            this.jrGroup = MGroup.createJRGroup(this.jrDataSet);
        }
    }

    public void execute() {
        block7: {
            this.createObject();
            if (this.jrGroup != null) {
                try {
                    if (this.index < 0 || this.index > this.jrDataSet.getGroupsList().size()) {
                        this.jrDataSet.addGroup(this.jrGroup);
                    } else {
                        this.jrDataSet.addGroup(this.index, this.jrGroup);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (e.getMessage().startsWith("Duplicate declaration of variable")) {
                        String defaultName = ModelUtils.getDefaultName(this.jrDataSet.getGroupsMap(), "CopyOFGroup_");
                        String message = MessageFormat.format(Messages.GroupSection_SameVariableNameErrorMsg, String.valueOf(this.jrGroup.getName()) + "_COUNT", this.jrGroup.getName());
                        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.common_group_name, message, defaultName, null);
                        if (dlg.open() == 0) {
                            this.jrGroup.setName(dlg.getValue());
                            this.execute();
                        }
                    }
                    if (!e.getMessage().startsWith("Duplicate declaration")) break block7;
                    String defaultName = ModelUtils.getDefaultName(this.jrDataSet.getGroupsMap(), "CopyOFGroup_");
                    InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.common_group_name, Messages.CreateGroupCommand_group_name_dialog_text, defaultName, null);
                    if (dlg.open() != 0) break block7;
                    this.jrGroup.setName(dlg.getValue());
                    this.execute();
                }
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDataSet.removeGroup((JRGroup)this.jrGroup);
    }
}

