/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group.command;

import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.band.command.CreateBandGroupFooterCommand;
import com.jaspersoft.studio.model.band.command.CreateBandGroupHeaderCommand;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.command.CreateGroupCommand;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.wizards.group.BandGroupWizard;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class CreateMainGroupCommand
extends CompoundCommand {
    private boolean addHeader = false;
    private boolean addFooter = false;
    private JRDesignGroup jrdGroup;
    private CreateBandGroupHeaderCommand createBandHeader;
    private CreateBandGroupFooterCommand createBandFooter;
    private MReport destNode;

    public CreateMainGroupCommand(MReport destNode, MGroup srcNode, int index) {
        super(Messages.CreateMainGroupCommand_create_main_group);
        this.add(new CreateGroupCommand(destNode, srcNode, index){

            @Override
            protected void createObject() {
                if (this.jrGroup == null) {
                    BandGroupWizard wizard = new BandGroupWizard();
                    wizard.init(this.jrDesign);
                    wizard.setExpressionContext(ExpressionEditorSupportUtil.getReportExpressionContext());
                    WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        MGroup srcNode = wizard.getGroup();
                        CreateMainGroupCommand.this.addHeader = wizard.isAddHeader();
                        CreateMainGroupCommand.this.addFooter = wizard.isAddFooter();
                        this.jrGroup = srcNode.getValue() == null ? MGroup.createJRGroup(this.jrDataSet) : (JRDesignGroup)srcNode.getValue();
                    }
                }
                CreateMainGroupCommand.this.setGroup(this.jrGroup);
            }
        });
        this.destNode = destNode;
    }

    private void setGroup(JRDesignGroup jrGroup) {
        this.jrdGroup = jrGroup;
    }

    public void execute() {
        Command cmd = (Command)this.getCommands().get(0);
        cmd.execute();
        if (this.addHeader) {
            if (this.createBandHeader == null) {
                for (INode n : this.destNode.getChildren()) {
                    if (!(n instanceof MBandGroupHeader) || ((MBandGroupHeader)n).getJrGroup() != this.jrdGroup) continue;
                    this.createBandHeader = new CreateBandGroupHeaderCommand((MBandGroupHeader)n);
                    break;
                }
            }
            if (this.createBandHeader != null) {
                this.createBandHeader.execute();
            }
        }
        if (this.addFooter) {
            if (this.createBandFooter == null) {
                for (INode n : this.destNode.getChildren()) {
                    if (!(n instanceof MBandGroupFooter) || ((MBandGroupFooter)n).getJrGroup() != this.jrdGroup) continue;
                    this.createBandFooter = new CreateBandGroupFooterCommand((MBandGroupFooter)n);
                    break;
                }
            }
            if (this.createBandFooter != null) {
                this.createBandFooter.execute();
            }
        }
        if (this.createBandHeader != null) {
            SelectionHelper.setOutlineSelection(this.createBandHeader.getCreatedElement());
        }
    }

    public void undo() {
        ((Command)this.getCommands().get(0)).undo();
        if (this.addHeader && this.createBandHeader != null) {
            this.createBandHeader.undo();
        }
        if (this.addFooter && this.createBandFooter != null) {
            this.createBandFooter.undo();
        }
    }
}

