/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.MGroups;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.eclipse.gef.commands.Command;

public class ReorderGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignGroup jrGroup;
    private JRDesignDataset jrDataset;

    public ReorderGroupCommand(MGroup child, MGroups parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = (JRDesignDataset)parent.getValue();
        this.jrGroup = (JRDesignGroup)child.getValue();
    }

    public void execute() {
        try {
            this.oldIndex = this.jrDataset.getGroupsList().indexOf(this.jrGroup);
            this.jrDataset.removeGroup((JRGroup)this.jrGroup);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getGroupsList().size()) {
                this.jrDataset.addGroup(this.jrGroup);
            } else {
                this.jrDataset.addGroup(this.newIndex, this.jrGroup);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDataset.removeGroup((JRGroup)this.jrGroup);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getGroupsList().size()) {
                this.jrDataset.addGroup(this.jrGroup);
            } else {
                this.jrDataset.addGroup(this.oldIndex, this.jrGroup);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

