/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.parameter;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.properties.JPropertiesPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MParameter
extends MParameterSystem
implements ICopyable {
    public static final String PROPERTY_MAP = "PROPERTY_MAP";
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static NamedEnumPropertyDescriptor<ParameterEvaluationTimeEnum> evaluationTimeD;
    private IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("parameter");
        }
        return iconDescriptor;
    }

    public MParameter() {
        this.setEditable(true);
    }

    public MParameter(ANode parent, JRDesignParameter jrParameter, int newIndex) {
        super(parent, jrParameter, newIndex);
        this.setEditable(true);
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NTextPropertyDescriptor descriptionD = new NTextPropertyDescriptor("description", Messages.common_description);
        descriptionD.setDescription(Messages.MParameter_description_description);
        desc.add((IPropertyDescriptor)descriptionD);
        descriptionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#parameterDescription"));
        CheckBoxPropertyDescriptor isForPromptingD = new CheckBoxPropertyDescriptor("isForPrompting", Messages.MParameter_is_for_prompting, NullEnum.NOTNULL);
        isForPromptingD.setDescription(Messages.MParameter_is_for_prompting_description);
        desc.add((IPropertyDescriptor)isForPromptingD);
        JRExpressionPropertyDescriptor defValueExprD = new JRExpressionPropertyDescriptor("defaultValueExpression", Messages.MParameter_default_value_expression);
        defValueExprD.setDescription(Messages.MParameter_default_value_expression_description);
        desc.add((IPropertyDescriptor)defValueExprD);
        defValueExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#defaultValueExpression"));
        JPropertiesPropertyDescriptor propertiesD = new JPropertiesPropertyDescriptor(PROPERTY_MAP, Messages.common_properties, this.getJasperConfiguration(), this.getValue());
        propertiesD.setDescription(Messages.MParameter_properties_description);
        desc.add((IPropertyDescriptor)propertiesD);
        propertiesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#property"));
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor("nestedType", Messages.MParameter_nested_type_name);
        classD.setDescription(Messages.MParameter_nested_type_name_description);
        desc.add((IPropertyDescriptor)classD);
        evaluationTimeD = new NamedEnumPropertyDescriptor<ParameterEvaluationTimeEnum>("evaluationTime", Messages.common_evaluation_time, ParameterEvaluationTimeEnum.EARLY, NullEnum.NULL);
        evaluationTimeD.setDescription(Messages.MParameter_3);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#parameter");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("isForPrompting", new DefaultValue(Boolean.TRUE, false));
        defaultsMap.put("nestedType", new DefaultValue(null, true));
        defaultsMap.put("evaluationTime", new DefaultValue(ParameterEvaluationTimeEnum.LATE, false));
        return defaultsMap;
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignParameter jrParameter = this.getValue();
        if (id.equals("description")) {
            return jrParameter.getDescription();
        }
        if (id.equals("isForPrompting")) {
            return jrParameter.isForPrompting();
        }
        if (id.equals("defaultValueExpression")) {
            return ExprUtil.getExpression(jrParameter.getDefaultValueExpression());
        }
        if (id.equals(PROPERTY_MAP)) {
            return jrParameter.getPropertiesMap();
        }
        if (id.equals("nestedType")) {
            return jrParameter.getNestedTypeName();
        }
        if (id.equals("evaluationTime")) {
            if (evaluationTimeD == null) {
                this.getPropertyDescriptors();
            }
            return evaluationTimeD.getIntValue(jrParameter.getEvaluationTime());
        }
        return super.getPropertyValue(id);
    }

    public static JRPropertiesMap getPropertiesMapClone(JRPropertiesHolder jrField) {
        JRPropertiesMap propertiesMap = jrField.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignParameter jrParameter = this.getValue();
        if (id.equals("evaluationTime")) {
            if (evaluationTimeD == null) {
                this.getPropertyDescriptors();
            }
            jrParameter.setEvaluationTime(evaluationTimeD.getEnumValue(value));
        } else if (id.equals("description")) {
            if (StringUtils.isNullOrEmpty((String)((String)value))) {
                jrParameter.setDescription(null);
            } else {
                jrParameter.setDescription((String)value);
            }
        } else if (id.equals("isForPrompting") && this.isMainDataset()) {
            jrParameter.setForPrompting(((Boolean)value).booleanValue());
        } else if (id.equals("nestedType")) {
            jrParameter.setNestedTypeName((String)value);
        } else if (id.equals("defaultValueExpression")) {
            jrParameter.setDefaultValueExpression(ExprUtil.setValues(jrParameter.getDefaultValueExpression(), value));
        } else if (id.equals(PROPERTY_MAP)) {
            JRPropertiesMap v = (JRPropertiesMap)value;
            String[] names = jrParameter.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrParameter.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            names = v.getPropertyNames();
            i = 0;
            while (i < names.length) {
                jrParameter.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                ++i;
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAP, false, true);
        }
        super.setPropertyValue(id, value);
    }

    public static JRDesignParameter createJRParameter(JRDesignDataset jrDataset) {
        JRDesignParameter jrDesignParameter = new JRDesignParameter();
        jrDesignParameter.setSystemDefined(false);
        jrDesignParameter.setName(ModelUtils.getDefaultName(jrDataset.getParametersMap(), "Parameter"));
        return jrDesignParameter;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionContext expContext;
            IPropertyDescriptor d = iPropertyDescriptorArray[n2];
            if (d.getId().equals("defaultValueExpression") && (expContext = this.getExpressionContext()) != null) {
                expContext.setVisibilities(EnumSet.of(ExpressionContext.Visibility.SHOW_PARAMETERS));
                ((IExpressionContextSetter)d).setExpressionContext(expContext);
            }
            ++n2;
        }
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MParameters) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public JRDesignDataset getDataset() {
        return ModelUtils.getDataset(this);
    }

    @Override
    public ExpressionContext getExpressionContext() {
        JRDesignDataset dataSet = ModelUtils.getDataset(this);
        JasperReportsConfiguration conf = this.getJasperConfiguration();
        if (dataSet != null && conf != null) {
            return new ExpressionContext(dataSet, conf);
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (ExpressionContext.class.equals((Object)adapter)) {
            return this.getExpressionContext();
        }
        return super.getAdapter(adapter);
    }

    public boolean isMainDataset() {
        MParameters prms;
        return this.getParent() instanceof MParameters && (prms = (MParameters)this.getParent()).getValue() instanceof JRDesignDataset && this.getJasperDesign().getMainDataset() == prms.getValue();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

