/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.parameter.command;

import com.jaspersoft.studio.editor.outline.actions.HideDefaultsParametersAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.gef.commands.Command;

public class ReorderParameterCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignParameter jrParameter;
    private JRDesignDataset jrDataset;
    private JasperReportsConfiguration jrContext;

    public ReorderParameterCommand(MParameter child, MParameters<?> parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.jrContext = parent.getJasperConfiguration();
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = (JRDesignDataset)parent.getValue();
        this.jrParameter = child.getValue();
    }

    public ReorderParameterCommand(JRDesignParameter child, JRDesignDataset jrDataset, JasperReportsConfiguration jrContext, int newIndex) {
        super(Messages.common_reorder_elements);
        this.jrContext = jrContext;
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = jrDataset;
        this.jrParameter = child;
    }

    public void execute() {
        this.oldIndex = this.jrDataset.getParametersList().indexOf(this.jrParameter);
        try {
            int i = 0;
            for (JRParameter v : this.jrDataset.getParametersList()) {
                if (!v.isSystemDefined()) break;
                ++i;
            }
            boolean showDefaults = this.jrContext != null ? this.jrContext.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
            boolean bl = showDefaults = showDefaults && !HideDefaultsParametersAction.areDefaultParametersHidden(this.jrContext);
            if (!showDefaults) {
                this.newIndex += i;
            }
            this.newIndex = Math.max(this.newIndex, i);
            this.jrDataset.removeParameter((JRParameter)this.jrParameter);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getParametersList().size()) {
                this.jrDataset.addParameter((JRParameter)this.jrParameter);
            } else {
                this.jrDataset.addParameter(this.newIndex, (JRParameter)this.jrParameter);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public boolean canExecute() {
        int i = 0;
        for (JRParameter v : this.jrDataset.getParametersList()) {
            if (!v.isSystemDefined()) break;
            ++i;
        }
        boolean showDefaults = this.jrContext != null ? this.jrContext.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
        boolean bl = showDefaults = showDefaults && !HideDefaultsParametersAction.areDefaultParametersHidden(this.jrContext);
        if (showDefaults) {
            return this.newIndex >= i;
        }
        return this.newIndex >= 0 && this.newIndex <= this.jrDataset.getParametersList().size();
    }

    public void undo() {
        try {
            this.jrDataset.removeParameter((JRParameter)this.jrParameter);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getParametersList().size()) {
                this.jrDataset.addParameter((JRParameter)this.jrParameter);
            } else {
                this.jrDataset.addParameter(this.oldIndex, (JRParameter)this.jrParameter);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

