/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.scriptlet;

import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.scriptlet.MScriptlets;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MScriptlet
extends APropertyNode
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("scriptlet");
        }
        return iconDescriptor;
    }

    public MScriptlet() {
    }

    public MScriptlet(ANode parent, JRScriptlet jfRield, int newIndex) {
        super(parent, newIndex);
        this.setValue(jfRield);
    }

    @Override
    public String getDisplayText() {
        return ((JRScriptlet)this.getValue()).getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MScriptlet.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MScriptlet.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        NTextPropertyDescriptor nameD = new NTextPropertyDescriptor("name", Messages.common_name);
        nameD.setDescription(Messages.MScriptlet_name_description);
        desc.add((IPropertyDescriptor)nameD);
        ArrayList clist = new ArrayList();
        clist.add(JRAbstractScriptlet.class);
        clist.add(JRDefaultScriptlet.class);
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor("valueClassName", Messages.common_class);
        classD.setClasses(clist);
        classD.setDescription(Messages.MScriptlet_class_description);
        desc.add((IPropertyDescriptor)classD);
        classD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#scriptlet_class"));
        NTextPropertyDescriptor descriptionD = new NTextPropertyDescriptor("description", Messages.common_description);
        descriptionD.setDescription(Messages.MScriptlet_description_description);
        desc.add((IPropertyDescriptor)descriptionD);
        descriptionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#scriptletDescription"));
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor((Object)"propertyExpressions", Messages.MScriptlet_PropertiesDescriptorMsg, false);
        propertiesD.setDescription(Messages.MScriptlet_PropertiesDescriptorDescription);
        desc.add((IPropertyDescriptor)propertiesD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#scriptlet");
    }

    public Object getPropertyValue(Object id) {
        JRDesignScriptlet scriptlet = (JRDesignScriptlet)this.getValue();
        if (id.equals("name")) {
            return scriptlet.getName();
        }
        if (id.equals("valueClassName")) {
            return scriptlet.getValueClassName();
        }
        if (id.equals("description")) {
            return scriptlet.getDescription();
        }
        if (id.equals("propertyExpressions")) {
            JRPropertyExpression[] propertyExpressions = scriptlet.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            return new PropertyExpressionsDTO(propertyExpressions, this.getPropertiesMapClone(scriptlet), this.getValue(), ModelUtils.getExpressionContext(this));
        }
        return null;
    }

    protected JRPropertiesMap getPropertiesMapClone(JRDesignScriptlet scriptlet) {
        JRPropertiesMap propertiesMap = scriptlet.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignScriptlet scriptlet = (JRDesignScriptlet)this.getValue();
        if (id.equals("name")) {
            if (value instanceof String && !((String)value).isEmpty()) {
                String newName = (String)value;
                String oldName = scriptlet.getName();
                JRDesignDataset d = ModelUtils.getDataset(this);
                if (d != null) {
                    Map pmap = d.getParametersMap();
                    JRDesignParameter p = (JRDesignParameter)pmap.get(String.valueOf(oldName) + "_SCRIPTLET");
                    if (p != null) {
                        p.setName(String.valueOf(newName) + "_SCRIPTLET");
                        pmap.remove(String.valueOf(oldName) + "_SCRIPTLET");
                        pmap.put(String.valueOf(newName) + "_SCRIPTLET", p);
                    }
                    scriptlet.setName(newName);
                }
            }
        } else if (id.equals("valueClassName")) {
            if (value instanceof String) {
                Map pmap;
                JRDesignParameter p;
                if (((String)value).isEmpty()) {
                    value = null;
                }
                scriptlet.setValueClassName((String)value);
                JRDesignDataset d = ModelUtils.getDataset(this);
                if (d != null && (p = (JRDesignParameter)(pmap = d.getParametersMap()).get(String.valueOf(scriptlet.getName()) + "_SCRIPTLET")) != null) {
                    p.setValueClassName(scriptlet.getValueClassName());
                }
            }
        } else if (id.equals("description")) {
            scriptlet.setDescription((String)value);
        } else if (id.equals("propertyExpressions") && value instanceof PropertyExpressionsDTO) {
            PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
            JRPropertyExpression[] expr = scriptlet.getPropertyExpressions();
            if (expr != null) {
                JRPropertyExpression[] jRPropertyExpressionArray = expr;
                int p = expr.length;
                int pmap = 0;
                while (pmap < p) {
                    JRPropertyExpression ex = jRPropertyExpressionArray[pmap];
                    scriptlet.removePropertyExpression(ex);
                    ++pmap;
                }
            }
            for (PropertyExpressionDTO p : dto.getProperties()) {
                if (!p.isExpression()) continue;
                JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                newExp.setName(p.getName());
                newExp.setValueExpression(p.getValueAsExpression());
                scriptlet.addPropertyExpression((JRPropertyExpression)newExp);
            }
            JRPropertiesMap originalMap = scriptlet.getPropertiesMap().cloneProperties();
            String[] names = scriptlet.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                scriptlet.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            for (PropertyExpressionDTO p : dto.getProperties()) {
                if (p.isExpression()) continue;
                scriptlet.getPropertiesMap().setProperty(p.getName(), p.getValue());
            }
            this.firePropertyChange(new PropertyChangeEvent(scriptlet, "PROPERTY_MAP", originalMap, scriptlet.getPropertiesMap()));
        }
    }

    public static JRDesignScriptlet createJRScriptlet(JRDesignDataset jrDataset) {
        JRDesignScriptlet jrScriptlet = new JRDesignScriptlet();
        jrScriptlet.setName(ModelUtils.getDefaultName(jrDataset.getScriptletsMap(), "Scriptlet_"));
        jrScriptlet.setValueClass(JRDefaultScriptlet.class);
        return jrScriptlet;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MScriptlets) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

