/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.sortfield.command.wizard.SortFieldWizard;
import com.jaspersoft.studio.model.sortfield.command.wizard.WizardSortFieldPage;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ChangeSortFieldTypeCommand
extends Command {
    private JRDesignDataset jrDataSet;
    private JRDesignSortField jrField;
    private String oldName;
    private SortFieldTypeEnum oldType;
    private SortFieldTypeEnum newValue;

    public ChangeSortFieldTypeCommand(MSortFields destNode, MSortField srcNode, SortFieldTypeEnum newValue) {
        this.jrDataSet = (JRDesignDataset)destNode.getValue();
        this.jrField = (JRDesignSortField)srcNode.getValue();
        this.newValue = newValue;
    }

    private String getSortFieldKey(JRSortField sortField) {
        return String.valueOf(sortField.getName()) + "|" + sortField.getType().getName();
    }

    public void execute() {
        if (this.jrField != null) {
            this.oldName = this.jrField.getName();
            this.oldType = this.jrField.getType();
            this.jrDataSet.getSortFieldsMap().remove(this.getSortFieldKey((JRSortField)this.jrField));
            SortFieldWizard wizard = new SortFieldWizard();
            JRDesignSortField dummyField = new JRDesignSortField();
            wizard.init(this.jrDataSet, dummyField);
            if (this.newValue != SortFieldTypeEnum.FIELD) {
                dummyField.setType(SortFieldTypeEnum.VARIABLE);
                wizard.setShownElementsType(WizardSortFieldPage.SHOW_TYPE.VARIABLES);
            } else {
                dummyField.setType(SortFieldTypeEnum.FIELD);
                wizard.setShownElementsType(WizardSortFieldPage.SHOW_TYPE.FIELDS);
            }
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() != 0) {
                this.oldName = null;
                this.oldType = null;
            } else {
                this.jrField.setType(dummyField.getType());
                this.jrField.setName(dummyField.getName());
            }
            this.jrDataSet.getSortFieldsMap().put(this.getSortFieldKey((JRSortField)this.jrField), this.jrField);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.oldName != null && this.oldType != null) {
            this.jrDataSet.getSortFieldsMap().remove(this.getSortFieldKey((JRSortField)this.jrField));
            this.jrField.setName(this.oldName);
            this.jrField.setType(this.oldType);
            this.jrDataSet.getSortFieldsMap().put(this.getSortFieldKey((JRSortField)this.jrField), this.jrField);
            this.oldName = null;
            this.oldType = null;
        }
    }
}

