/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import org.eclipse.gef.commands.Command;

public class ReplaceAllSortFieldsCommand
extends Command {
    private List<JRDesignSortField> oldSortFields;
    private List<JRDesignSortField> newOrderedSortFields;
    private JRDesignDataset jrDataset;

    public ReplaceAllSortFieldsCommand(List<JRDesignSortField> children, MSortFields mSortFields) {
        super(Messages.ReplaceAllSortFieldsCommand_Label);
        this.jrDataset = (JRDesignDataset)mSortFields.getValue();
        this.newOrderedSortFields = children;
        this.oldSortFields = new ArrayList<JRDesignSortField>(this.jrDataset.getSortFieldsList().size());
    }

    public void execute() {
        try {
            JRSortField[] originalSortFields = this.jrDataset.getSortFields();
            int i = 0;
            while (i < originalSortFields.length) {
                this.jrDataset.removeSortField(originalSortFields[i]);
                this.oldSortFields.add((JRDesignSortField)originalSortFields[i]);
                ++i;
            }
            int j = 0;
            while (j < this.newOrderedSortFields.size()) {
                this.jrDataset.addSortField((JRSortField)this.newOrderedSortFields.get(j));
                ++j;
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllSortFieldsCommand_ExecuteError, (Throwable)e);
        }
    }

    public void undo() {
        try {
            JRSortField[] sortFields;
            JRSortField[] jRSortFieldArray = sortFields = this.jrDataset.getSortFields();
            int n = sortFields.length;
            int n2 = 0;
            while (n2 < n) {
                JRSortField jRSortField = jRSortFieldArray[n2];
                this.jrDataset.removeSortField(jRSortField);
                ++n2;
            }
            for (JRSortField jRSortField : this.oldSortFields) {
                this.jrDataset.addSortField(jRSortField);
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllSortFieldsCommand_UndoError, (Throwable)e);
        }
    }
}

