/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyleTemplateReference;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.utils.CacheMap;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class StyleTemplateFactory {
    private static Map<JasperDesign, String[]> cstyles = new CacheMap<JasperDesign, String[]>(2000);

    public static ANode createNode(ANode parent, Object obj, int index, IFile templateStyleFile, JRSimpleTemplate jrst) {
        if (obj instanceof JRDesignStyle) {
            return new MStyle(parent, (JRDesignStyle)obj, index += jrst.getIncludedTemplatesList().size());
        }
        if (obj instanceof JRTemplateReference) {
            MStyleTemplateReference n = new MStyleTemplateReference(parent, (JRTemplateReference)obj, index);
            StyleTemplateFactory.createTemplateReference(n, ((JRTemplateReference)obj).getLocation(), -1, new HashSet<String>(), false);
        }
        return null;
    }

    public static ANode createTemplate(ANode parent, JRDesignReportTemplate jrObject, int newIndex, IFile file) {
        MStyleTemplate mStyleTemplate = new MStyleTemplate(parent, (JRReportTemplate)jrObject, newIndex);
        JasperReportsConfiguration jConf = parent.getJasperConfiguration();
        IFile project = (IFile)jConf.get("ifile");
        String str = ExternalStylesManager.evaluateStyleExpression((JRReportTemplate)jrObject, project, jConf);
        if (str != null) {
            StyleTemplateFactory.createTemplateReference(mStyleTemplate, str, -1, new HashSet<String>(), false);
            return mStyleTemplate;
        }
        return null;
    }

    public static boolean createTemplateReference(ANode parent, String location, int newIndex, Set<String> loadedResources, boolean editable) {
        JasperReportsConfiguration jConfig;
        JRTemplate jrst;
        if (!loadedResources.contains(location) && (jrst = ExternalStylesManager.getTemplate(jConfig = parent.getJasperConfiguration(), location)) != null) {
            loadedResources.add(location);
            StyleTemplateFactory.createTemplate(parent, loadedResources, editable, jrst);
            return true;
        }
        return false;
    }

    public static void createTemplate(ANode parent, Set<String> loadedResources, boolean editable, JRTemplate jrst) {
        JRTemplateReference s;
        JRTemplateReference[] jRTemplateReferenceArray = jrst.getIncludedTemplates();
        int n = jRTemplateReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = jRTemplateReferenceArray[n2];
            MStyleTemplateReference p = new MStyleTemplateReference(parent, s, -1);
            p.setEditable(editable);
            StyleTemplateFactory.createTemplateReference(p, s.getLocation(), -1, loadedResources, editable);
            ++n2;
        }
        jRTemplateReferenceArray = jrst.getStyles();
        n = jRTemplateReferenceArray.length;
        n2 = 0;
        while (n2 < n) {
            s = jRTemplateReferenceArray[n2];
            APropertyNode n3 = (APropertyNode)ReportFactory.createNode(parent, s, -2);
            n3.setEditable(editable);
            if (((JRDesignStyle)s).getConditionalStyleList() != null) {
                for (Object jrc : ((JRDesignStyle)s).getConditionalStyleList()) {
                    ANode conditionalStyle = ReportFactory.createNode(n3, jrc, -1);
                    conditionalStyle.setEditable(editable);
                }
            }
            ++n2;
        }
    }

    public static void createTemplateRoot(ANode parent, Set<String> set, IFile file, JRSimpleTemplate jrst) {
        JRTemplateReference s;
        JasperDesign jd = parent.getJasperDesign();
        JRTemplateReference[] jRTemplateReferenceArray = jrst.getIncludedTemplates();
        int n = jRTemplateReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = jRTemplateReferenceArray[n2];
            MStyleTemplateReference p = new MStyleTemplateReference(parent, s, -1);
            p.setEditable(true);
            StyleTemplateFactory.createTemplateReference(p, s.getLocation(), -1, set, false);
            ++n2;
        }
        jRTemplateReferenceArray = jrst.getStyles();
        n = jRTemplateReferenceArray.length;
        n2 = 0;
        while (n2 < n) {
            s = jRTemplateReferenceArray[n2];
            APropertyNode n3 = (APropertyNode)ReportFactory.createNode(parent, s, -2);
            n3.setEditable(true);
            if (jd != null) {
                try {
                    jd.addStyle((JRStyle)s);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            if (((JRDesignStyle)s).getConditionalStyleList() != null) {
                for (Object jrc : ((JRDesignStyle)s).getConditionalStyleList()) {
                    ReportFactory.createNode(n3, jrc, -1);
                }
            }
            ++n2;
        }
        for (INode node : parent.getChildren()) {
            if (!(node instanceof MStyleTemplateReference) || jd == null) continue;
            MStyleTemplateReference externalNode = (MStyleTemplateReference)node;
            JRTemplateReference externalValue = (JRTemplateReference)externalNode.getValue();
            JRDesignReportTemplate jrTemplate = MStyleTemplate.createJRTemplate();
            JRDesignExpression jre = new JRDesignExpression();
            jre.setText("\"" + externalValue.getLocation() + "\"");
            jrTemplate.setSourceExpression((JRExpression)jre);
            jd.addTemplate((JRReportTemplate)jrTemplate);
        }
    }

    protected static final File getFile(String location, IFile file) {
        return SelectionHelper.resolveFile(file, location);
    }

    protected static String getStylePath(JRTemplateReference s, File fileToBeOpened, IFile file) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] fs = root.findFilesForLocationURI(fileToBeOpened.toURI());
        if (fs != null && fs.length > 0) {
            File absoluteFile = StyleTemplateFactory.getFile(s.getLocation(), fs[0]);
            return absoluteFile != null ? absoluteFile.getAbsolutePath() : s.getLocation();
        }
        File absoluteFile = StyleTemplateFactory.getFile(s.getLocation(), file);
        return absoluteFile != null ? absoluteFile.getAbsolutePath() : s.getLocation();
    }

    public static String getStylePath(JRTemplateReference p, JasperReportsConfiguration jConfig) {
        IFile resource = (IFile)jConfig.get("ifile");
        File file = resource.getLocation().toFile();
        return StyleTemplateFactory.getStylePath(p, file, resource);
    }

    public static void openEditor(Object obj, IEditorInput editorInput, ANode node) {
        if (obj instanceof JRStyle || obj instanceof JRConditionalStyle) {
            if (node.getParent() instanceof MStyles) {
                return;
            }
            if (node instanceof MConditionalStyle) {
                node = node.getParent();
            }
            if (node instanceof MStyle) {
                node = node.getParent();
            }
        }
        if (node instanceof MStyleTemplate) {
            obj = node.getValue();
        } else if (node instanceof MStyleTemplateReference) {
            IFile file = StyleTemplateFactory.getFile(node, ((FileEditorInput)editorInput).getFile());
            JRTemplateReference st = (JRTemplateReference)node.getValue();
            SelectionHelper.openEditor(file, st.getLocation());
        }
        if (obj instanceof JRDesignReportTemplate) {
            JRDesignReportTemplate s;
            if (editorInput instanceof FileEditorInput && (s = (JRDesignReportTemplate)obj).getSourceExpression() != null) {
                SelectionHelper.openEditor((FileEditorInput)editorInput, ExpressionUtil.cachedExpressionEvaluationString(s.getSourceExpression(), node.getJasperConfiguration()));
            }
            return;
        }
    }

    private static IFile getFile(ANode node, IFile refFile) {
        ArrayList<Object> plist = new ArrayList<Object>();
        ANode p = node;
        JasperReportsConfiguration jConfig = node.getJasperConfiguration();
        plist.add(p.getValue());
        while (!(p.getParent() instanceof MStyles)) {
            p = p.getParent();
            plist.add(p.getValue());
        }
        MStyleTemplate mst = (MStyleTemplate)p;
        JRDesignReportTemplate drt = (JRDesignReportTemplate)mst.getValue();
        return StyleTemplateFactory.resolveTemplates(refFile, plist, jConfig, drt);
    }

    public static String[] getAllStyles(JasperReportsConfiguration jConf, JRDesignElement jrElement) {
        JasperDesign jd = jConf.getJasperDesign();
        String[] items = cstyles.get(jd);
        if (items == null) {
            if (jd == null) {
                return new String[0];
            }
            JRStyle[] styles = jd.getStyles();
            List<JRStyle> slist = StyleTemplateFactory.getStyles(jConf, jd, (IFile)jConf.get("ifile"));
            ArrayList<String> itemsList = new ArrayList<String>();
            itemsList.add("");
            JRStyle[] jRStyleArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                JRStyle style = jRStyleArray[n2];
                itemsList.add(style.getName());
                ++n2;
            }
            for (JRStyle style : slist) {
                itemsList.add(style.getName());
            }
            items = itemsList.toArray(new String[itemsList.size()]);
            cstyles.put(jd, items);
        }
        return items;
    }

    public static String[] getAllStyles(JasperReportsConfiguration jConf, JRBaseStyle jrStyle) {
        JasperDesign jd = jConf.getJasperDesign();
        if (jd == null) {
            return new String[0];
        }
        JRStyle[] styles = jd.getStyles();
        List<JRStyle> slist = StyleTemplateFactory.getStyles(jConf, jd, (IFile)jConf.get("ifile"));
        String actualStyleName = jrStyle.getName();
        ArrayList<String> availableStyles = new ArrayList<String>();
        availableStyles.add("");
        JRStyle[] jRStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            JRStyle style = jRStyleArray[n2];
            if (!style.getName().equals(actualStyleName)) {
                availableStyles.add(style.getName());
            }
            ++n2;
        }
        for (JRStyle style : slist) {
            availableStyles.add(style.getName());
        }
        return availableStyles.toArray(new String[availableStyles.size()]);
    }

    private static List<JRStyle> getStyles(JasperReportsConfiguration jConfig, JasperDesign jd, IFile file) {
        ArrayList<JRStyle> list = new ArrayList<JRStyle>();
        for (JRReportTemplate t : jd.getTemplatesList()) {
            list.addAll(ExternalStylesManager.getStyles(t, file, jConfig));
        }
        return list;
    }

    protected static IFile resolveTemplates(IFile refFile, List<Object> plist, JasperReportsConfiguration jConfig, JRDesignReportTemplate drt) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String str = ExpressionUtil.cachedExpressionEvaluationString(drt.getSourceExpression(), jConfig);
        if (str != null) {
            if (refFile == null) {
                refFile = ((IFileEditorInput)SelectionHelper.getActiveJRXMLEditor().getEditorInput()).getFile();
            }
            int i = plist.size() - 1;
            while (i >= 0) {
                Object obj = plist.get(i);
                if (obj instanceof JRDesignReportTemplate) {
                    str = ExpressionUtil.cachedExpressionEvaluationString(((JRDesignReportTemplate)obj).getSourceExpression(), jConfig);
                } else if (obj instanceof JRTemplateReference) {
                    str = ((JRTemplateReference)obj).getLocation();
                }
                File fileToBeOpened = SelectionHelper.resolveFile(refFile, str);
                if (fileToBeOpened != null && fileToBeOpened.exists() && fileToBeOpened.isFile()) {
                    IFile[] fs = root.findFilesForLocationURI(fileToBeOpened.toURI());
                    if (fs == null || fs.length <= 0) break;
                    refFile = fs[0];
                }
                --i;
            }
            return refFile;
        }
        return null;
    }
}

